/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeApplicationRoleInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeTypes;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.scheme.SchemeEntity;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SchemeApplicationRoleInspectorImpl
implements SchemeApplicationRoleInspector {
    private final ApplicationRoleManager applicationRoleManager;

    public SchemeApplicationRoleInspectorImpl(ApplicationRoleManager applicationRoleManager) {
        this.applicationRoleManager = applicationRoleManager;
    }

    @Override
    public Iterable<InspectionNote> inspect(Iterable<SchemeEntity> entities, InspectionContext context) {
        if (this.hasAnyLoggedInUserRole(entities)) {
            return this.anyLoggedInUserAllowed(context);
        }
        List<ApplicationRole> applicationRoles = this.getApplicationRoles(entities);
        if (applicationRoles.isEmpty()) {
            return Collections.emptyList();
        }
        if (context.isAnonymous()) {
            return this.noAnonymousUsers(context);
        }
        List<ApplicationRole> applicationRolesUserIsIn = this.getApplicationRolesUserIsIn(context, applicationRoles);
        if (!applicationRolesUserIsIn.isEmpty()) {
            return this.applicationRoleFound(context, applicationRolesUserIsIn);
        }
        return this.noMatchingApplicationRoleFound(context, applicationRoles);
    }

    private Iterable<InspectionNote> anyLoggedInUserAllowed(InspectionContext context) {
        return Lists.newArrayList((Object[])new InspectionNote[]{InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey(SchemeApplicationRoleInspector.TemplateKey.ANY_LOGGED_IN_USER.getKey()).build()).build()});
    }

    private Iterable<InspectionNote> noAnonymousUsers(InspectionContext context) {
        return Lists.newArrayList((Object[])new InspectionNote[]{InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, SchemeApplicationRoleInspector.TemplateKey.NO_ANONYMOUS_USER.getKey())).build()});
    }

    private Iterable<InspectionNote> noMatchingApplicationRoleFound(InspectionContext context, List<ApplicationRole> applicationRoles) {
        String username = context.user().getUsername();
        List<String> applicationRoleNames = this.getApplicationRoleNames(applicationRoles);
        return Lists.newArrayList((Object[])new InspectionNote[]{InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey(applicationRoleNames.size() > 1 ? SchemeApplicationRoleInspector.TemplateKey.NO_MATCHING_APP_ROLE_MULTI.getKey() : SchemeApplicationRoleInspector.TemplateKey.NO_MATCHING_APP_ROLE.getKey()).addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(StringUtils.join(applicationRoleNames, (String)", ")).build()).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.applicationrole.problem.fix").newI18nLinkParameter().pathKey("whereismycf.inspection.link.applicationrole").urlParams(username).textKey("permissionhelper.inspection.viewissue.applicationrole.problem.linktext").add().build()).build()});
    }

    private Iterable<InspectionNote> applicationRoleFound(InspectionContext context, List<ApplicationRole> applicationRolesUserIsIn) {
        List<String> applicationRoleNames = this.getApplicationRoleNames(applicationRolesUserIsIn);
        return Lists.newArrayList((Object[])new InspectionNote[]{InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey(applicationRoleNames.size() > 1 ? SchemeApplicationRoleInspector.TemplateKey.MATCHING_APP_ROLE_MULTI.getKey() : SchemeApplicationRoleInspector.TemplateKey.MATCHING_APP_ROLE.getKey()).addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(StringUtils.join(applicationRoleNames, (String)", ")).build()).build()});
    }

    private List<ApplicationRole> getApplicationRoles(Iterable<SchemeEntity> entities) {
        ArrayList applicationRoles = Lists.newArrayList();
        for (SchemeEntity schemeEntity : Iterables.filter(entities, SchemeTypes.isOfType("applicationRole"))) {
            String applicationKey;
            ApplicationKey key;
            Option applicationRole;
            if (schemeEntity.getParameter() == null || schemeEntity.getParameter().equals("") || !(applicationRole = this.applicationRoleManager.getRole(key = ApplicationKey.valueOf((String)(applicationKey = schemeEntity.getParameter())))).isDefined()) continue;
            applicationRoles.add(applicationRole.get());
        }
        return applicationRoles;
    }

    private List<ApplicationRole> getApplicationRolesUserIsIn(final InspectionContext context, List<ApplicationRole> roles) {
        return roles.stream().filter(new Predicate<ApplicationRole>(){

            @Override
            public boolean test(ApplicationRole applicationRole) {
                return SchemeApplicationRoleInspectorImpl.this.applicationRoleManager.userHasRole(context.user(), applicationRole.getKey());
            }
        }).collect(Collectors.toList());
    }

    private List<String> getApplicationRoleNames(List<ApplicationRole> projectRoles) {
        return projectRoles.stream().map(new Function<ApplicationRole, String>(){

            @Override
            public String apply(ApplicationRole projectRole) {
                return projectRole.getName();
            }
        }).collect(Collectors.toList());
    }

    private boolean hasAnyLoggedInUserRole(Iterable<SchemeEntity> entities) {
        return Lists.newArrayList(entities).stream().anyMatch(new Predicate<SchemeEntity>(){

            @Override
            public boolean test(SchemeEntity schemeEntity) {
                return null == schemeEntity.getParameter() || schemeEntity.getParameter().equals("");
            }
        });
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, SchemeApplicationRoleInspector.TemplateKey.APPLICATION_ROLE_SUMMARY.getKey());
    }
}

