/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionIssueSecurityInspector
implements ProjectPermissionInspector {
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;

    @Autowired
    public PermissionIssueSecurityInspector(IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    @Override
    public Iterable<InspectionNote> inspect(PermissionInspectionContext context) {
        boolean hasPerm = this.issueSecuritySchemeManager.hasSecurityLevelAccess(context.issue(), context.user());
        ArrayList notes = Lists.newArrayList();
        if (hasPerm) {
            if (context.issue().getSecurityLevelId() != null) {
                notes.add(InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.issuesecurity.ok").addPlainParameter(UserHelper.getDisplayName(context)).newI18nLinkParameter().pathKey("permissionhelper.inspection.issuesecurity.link").urlParams(context.issue().getSecurityLevel().get("scheme").toString()).textKey("permissionhelper.inspection.issuesecurity.linktext").textParams(context.issue().getSecurityLevel().get("name")).add().build()).required(true).build());
            }
        } else {
            notes.add(InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.issuesecurity.problem").addPlainParameter(UserHelper.getDisplayName(context)).newI18nLinkParameter().pathKey("permissionhelper.inspection.issuesecurity.link").urlParams(context.issue().getSecurityLevel().get("scheme").toString()).textKey("permissionhelper.inspection.issuesecurity.linktext").textParams(context.issue().getSecurityLevel().get("name")).add().build()).required(true).build());
        }
        return notes;
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.issuesecurity.summary");
    }
}

