/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.IdentifiableInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;

public class ScreenInspector
extends AbstractFieldInspector<Field>
implements FieldInspector<Field>,
IdentifiableInspector {
    public static final String INSPECTION_ID = "com.atlassian.jira.customfieldhelper.inspection.SCREEN";
    private final IssueTypeScreenSchemeManager screenSchemeManager;

    public ScreenInspector(IssueTypeScreenSchemeManager screenSchemeManager) {
        super(Field.class);
        this.screenSchemeManager = screenSchemeManager;
    }

    @Override
    @Nonnull
    public String inspectionId() {
        return INSPECTION_ID;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(Field field, FieldInspectionContext context) {
        if (context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION && !context.isOfType(CustomField.class)) {
            return Collections.emptyList();
        }
        FieldScreenScheme fieldScreenScheme = this.screenSchemeManager.getFieldScreenScheme(context.issue());
        FieldScreen screen = fieldScreenScheme.getFieldScreen(context.issueOperation());
        if (screen.containsField(field.getId())) {
            return ImmutableList.of((Object)this.createOk(field, context, screen));
        }
        return ImmutableList.of((Object)this.createNotOnScreenIssue(field, fieldScreenScheme, context, screen));
    }

    private InspectionNote createOk(Field field, FieldInspectionContext context, FieldScreen screen) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(field, context, screen)).build();
    }

    private InspectionNote createNotOnScreenIssue(Field field, FieldScreenScheme fieldScreenScheme, FieldInspectionContext context, FieldScreen screen) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createProblemDetails(field, fieldScreenScheme, context, screen)).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.screen.summary").build();
    }

    private InspectionMessage createOkDetails(Field field, FieldInspectionContext context, FieldScreen screen) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.screen.ok").addPlainParameter(field.getName()).addPlainParameter(screen.getName()).build();
    }

    private InspectionMessage createProblemDetails(Field field, FieldScreenScheme fieldScreenScheme, FieldInspectionContext context, FieldScreen screen) {
        IssueTypeScreenScheme issueTypeScreenScheme = this.screenSchemeManager.getIssueTypeScreenScheme(context.project());
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.screen.problem").addPlainParameter(field.getName()).addPlainParameter(screen.getName()).addNewLine().newI18nLinkParameter().textKey("whereismycf.inspection.screen.problem.linktext.screenconfig").textParams(screen.getName()).pathKey("whereismycf.inspection.link.screenconfiguration").urlParams(screen.getId()).add().addTagStart("ul").addTagStart("li").newI18nLinkParameter().textKey("whereismycf.inspection.screen.problem.linktext.fieldscreenschemeconfig").textParams(fieldScreenScheme.getName()).pathKey("whereismycf.inspection.link.fieldscreenschemeconfiguration").urlParams(fieldScreenScheme.getId()).add().addTagEnd("li").newI18nLinkParameter().textKey("whereismycf.inspection.screen.problem.linktext.issuetypescreenschemeconfig").textParams(issueTypeScreenScheme.getName()).pathKey("whereismycf.inspection.link.issuetypescreenschemeconfiguration").urlParams(issueTypeScreenScheme.getId()).add().addTagEnd("ul").build();
    }
}

