/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkedIssuesInspector
extends AbstractFieldInspector<IssueLinksSystemField> {
    private final IssueLinkManager localLinkManager;
    private final RemoteIssueLinkManager remoteLinkManager;

    @Autowired
    public LinkedIssuesInspector(IssueLinkManager localLinkManager, RemoteIssueLinkManager remoteLinkManager) {
        super(IssueLinksSystemField.class);
        this.localLinkManager = localLinkManager;
        this.remoteLinkManager = remoteLinkManager;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(IssueLinksSystemField field, FieldInspectionContext context) {
        ImmutableList.Builder inspections = ImmutableList.builder();
        if (this.localLinkManager.isLinkingEnabled()) {
            inspections.add((Object)this.createIssueLinkingOk(context));
        } else {
            inspections.add((Object)this.createIssueLinkingProblem(context));
        }
        if (context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION) {
            context.excludeAll();
            if (this.hasAnyLinks(context)) {
                inspections.add((Object)this.createHasLinks(field, context));
            } else {
                inspections.add((Object)this.createNoLinks(field, context));
            }
        }
        return inspections.build();
    }

    private boolean hasAnyLinks(FieldInspectionContext context) {
        return !this.localLinkManager.getLinkCollection(context.issue(), context.user()).getAllIssues().isEmpty() || !this.remoteLinkManager.getRemoteIssueLinksForIssue(context.issue()).isEmpty();
    }

    private InspectionNote createIssueLinkingOk(FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createIssueLinkingSummary(context)).addDetails(this.createIssueLinkingOkDetails(context)).build();
    }

    private InspectionNote createIssueLinkingProblem(FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createIssueLinkingSummary(context)).addDetails(this.createIssueLinkingProblemDetails(context)).build();
    }

    private InspectionNote createHasLinks(IssueLinksSystemField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createHasLinksSummary(context)).addDetails(this.createHasLinksOkDetails(context)).build();
    }

    private InspectionNote createNoLinks(IssueLinksSystemField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createHasLinksSummary(context)).addDetails(this.createHasLinksProblemDetails(context)).build();
    }

    private InspectionMessage createIssueLinkingSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.issuelinks.linkingsetting.summary");
    }

    private InspectionMessage createIssueLinkingOkDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.issuelinks.linkingsetting.ok");
    }

    private InspectionMessage createIssueLinkingProblemDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.issuelinks.linkingsetting.problem").addNewLine().addLinkParameterFromI18n("whereismycf.inspection.issuelinks.linkingsetting.problem.linktext.issuelinking", "whereismycf.inspection.link.issuelinks", new Object[0]).build();
    }

    private InspectionMessage createHasLinksSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.issuelinks.haslinks.summary");
    }

    private InspectionMessage createHasLinksOkDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.issuelinks.haslinks.ok").addPlainParameter(context.issue().getKey()).build();
    }

    private InspectionMessage createHasLinksProblemDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.issuelinks.haslinks.problem").addPlainParameter(context.issue().getKey()).build();
    }
}

