/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.FieldInspector;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.Field;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Collections;
import javax.annotation.Nonnull;

public class ConditionalInspector<F extends Field>
extends AbstractFieldInspector<F>
implements FieldInspector<F> {
    private final FieldInspector<F> inspector;
    private final Predicate<FieldInspectionContext> predicate;

    public static <G extends Field> ConditionalInspector<G> conditional(FieldInspector<G> inspector, Predicate<FieldInspectionContext> condition) {
        return new ConditionalInspector<G>(inspector, condition);
    }

    private ConditionalInspector(FieldInspector<F> decorated, Predicate<FieldInspectionContext> predicate) {
        super(decorated.supportedType());
        this.inspector = (FieldInspector)Preconditions.checkNotNull(decorated, (Object)"decorated");
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate, (Object)"predicate");
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(F field, FieldInspectionContext context) {
        if (this.predicate.apply((Object)context)) {
            return this.inspector.inspect(field, context);
        }
        return Collections.emptyList();
    }
}

