/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.customfieldhelper.versions.JiraVersionChecker;
import com.atlassian.jira.customfieldhelper.versions.JiraVersions;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ComponentsSystemFieldInspector
extends AbstractFieldInspector<ComponentsSystemField> {
    private final JiraVersionChecker jiraVersionChecker;

    @Autowired
    public ComponentsSystemFieldInspector(JiraVersionChecker jiraVersionChecker) {
        super(ComponentsSystemField.class);
        this.jiraVersionChecker = jiraVersionChecker;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(ComponentsSystemField field, FieldInspectionContext context) {
        if (context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION && this.jiraVersionChecker.isEqualOrLaterThan(JiraVersions.jira51())) {
            if (context.project().getProjectComponents().isEmpty()) {
                return ImmutableList.of((Object)this.createProblemNote(context));
            }
            return ImmutableList.of((Object)this.createOkNote(context));
        }
        return Collections.emptyList();
    }

    private InspectionNote createOkNote(FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(ComponentsSystemFieldInspector.summary(context)).addDetails(this.createOkDetails(context)).build();
    }

    private InspectionNote createProblemNote(FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(ComponentsSystemFieldInspector.summary(context)).addDetails(this.createProblemDetails(context)).build();
    }

    private static InspectionMessage summary(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.components.view.summary").build();
    }

    private InspectionMessage createOkDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.components.view.ok").addPlainParameter(context.project().getName()).build();
    }

    private InspectionMessage createProblemDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.components.view.problem").addPlainParameter(context.project().getName()).addNewLine().addLinkParameterFromI18n("whereismycf.inspection.components.view.problem.linktext.projectcomponents", "whereismycf.inspection.link.projectcomponents", context.project().getKey()).build();
    }
}

