/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.fields.AttachmentSystemField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;

public class AttachmentValueOnViewInspector
extends AbstractFieldInspector<AttachmentSystemField> {
    private final AttachmentManager attachmentManager;

    public AttachmentValueOnViewInspector(AttachmentManager attachmentManager) {
        super(AttachmentSystemField.class);
        this.attachmentManager = attachmentManager;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(AttachmentSystemField field, FieldInspectionContext context) {
        context.exclude("com.atlassian.jira.customfieldhelper.inspection.VIEW_OPERATION_VALUE");
        if (context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION) {
            if (this.attachmentManager.getAttachments(context.issue()).isEmpty()) {
                return ImmutableList.of((Object)this.createProblem(field, context));
            }
            return ImmutableList.of((Object)this.createOk(field, context));
        }
        return Collections.emptyList();
    }

    private InspectionNote createOk(AttachmentSystemField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(context)).build();
    }

    private InspectionNote createProblem(AttachmentSystemField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createProblemDetails(context)).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.attachment.view.summary");
    }

    private InspectionMessage createOkDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.attachment.view.ok");
    }

    private InspectionMessage createProblemDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.attachment.view.problem");
    }
}

