/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.fields.AttachmentSystemField;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import javax.annotation.Nonnull;

public class AttachmentSystemFieldInspector
extends AbstractFieldInspector<AttachmentSystemField> {
    private final AttachmentManager attachmentManager;

    public AttachmentSystemFieldInspector(AttachmentManager attachmentManager) {
        super(AttachmentSystemField.class);
        this.attachmentManager = attachmentManager;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(AttachmentSystemField field, FieldInspectionContext context) {
        if (context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION) {
            return Collections.emptyList();
        }
        if (this.attachmentManager.attachmentsEnabled()) {
            return ImmutableList.of((Object)this.createOk(field, context));
        }
        return ImmutableList.of((Object)this.createProblem(field, context));
    }

    private InspectionNote createOk(AttachmentSystemField field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createSummary(context)).addDetails(this.createOkDetails(context)).build();
    }

    private InspectionNote createProblem(AttachmentSystemField field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(context)).addDetails(this.createProblemDetails(context)).build();
    }

    private InspectionMessage createSummary(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.attachment.summary");
    }

    private InspectionMessage createOkDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.attachment.ok");
    }

    private InspectionMessage createProblemDetails(FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.attachment.problem").addNewLine().addLinkParameterFromI18n("whereismycf.inspection.attachment.problem.linktext.attachmentconfig", "whereismycf.inspection.link.attachments", new Object[0]).build();
    }
}

