(function($) {

    var LABEL = AJS.I18n.getText('whereismycf.dialog.title');

    JIRA.WhereIsMyCf.dialog = new JIRA.WhereIsMyCf.WhereIsMyCfDialog;
    $(document).delegate(".whereismycf-trigger", "click", function(event) {
        event.preventDefault();
        AJS.trigger('analyticsEvent', {name: 'adminhelper.whereismycf.dialog.open'});
        JIRA.WhereIsMyCf.dialog.show(createViewContext());
    });
    // hook into the quick-edit
    $(document).bind("showLayer", function(event, control, hash) {
        if (control == "inlineDialog" && hash.popup.attr("id") == "inline-dialog-field_picker_popup") {
            if (hash.popup.find(".whereismycf-qfpicker-link").length == 0) {
                var thelink = $("<a href='#' class='whereismycf-qfpicker-link'>" + LABEL + "</a>").appendTo(hash.popup.find(".qf-picker-header dl"));
                thelink.click(function(event) {
                    event.preventDefault();
                    hash.hide();
                    eventsAndDecouplingInJavaScriptAreSoooAwesome();
                    JIRA.WhereIsMyCf.dialog.show(createQfContext());
                });
            }
        }
    });

    function eventsAndDecouplingInJavaScriptAreSoooAwesome() {
        // we're doing this because LayerManager wants to outsmart the world by deciding what to hide and what not...
        // and InlineDialog (and everything else in AUI) wants to outsmart the world by applying stupid timeouts to everything...
        // but ultimately you can outsmart every smartass in the JS land just by setting global variables to null! BUAHAHAHAHAHAHA
        AJS.InlineDialog.current = null;
    }

    function getIssueKey() {
        var issueKey = JIRA.Issue.getIssueKey();
        if (!issueKey && JIRA.IssueNavigator) {
            issueKey = JIRA.IssueNavigator.getSelectedIssueKey();
        }
        return issueKey;
    }

    function createViewContext() {
        return new JIRA.WhereIsMyCf.IssueContext({
            issueKey: getIssueKey(),
            issueOperation: JIRA.WhereIsMyCf.dialog.OPERATION_VIEW
        });
    }

    function createQfContext() {
        var currentDialog = JIRA.Dialog.current;
        if (currentDialog.options.id == "create-issue-dialog") {
            return createQfCreateContext(currentDialog);
        } else if (currentDialog.options.id == "edit-issue-dialog") {
            return createQfEditContext(currentDialog);
        } else {
            throw "Uknown current dialog ID: " + currentDialog.options.id;
        }
    }

    function createQfCreateContext(dialog) {
        var contents = dialog.get$popupContent();
        return new JIRA.WhereIsMyCf.IssueContext({
            projectId: contents.find("#project").find("option:selected").val(),
            issueTypeId: contents.find("#issuetype").find("option:selected").val(),
            issueOperation: JIRA.WhereIsMyCf.dialog.OPERATION_CREATE
        });
    }

    function createQfEditContext(dialog) {
        var contents = dialog.get$popupContent();
        return new JIRA.WhereIsMyCf.IssueContext({
            issueKey: getIssueKey(),
            issueTypeId: contents.find("#issuetype").find("option:selected").val(),
            issueOperation: JIRA.WhereIsMyCf.dialog.OPERATION_EDIT
        });
    }

})(AJS.$);
