(function($) {

    $(function () {
        if (isOnEditPermissionsPage()) {
            var $header = getHeaderOnEditPermissionsPage();
            $header.append($(JIRA.Templates.Nav.PermissionHelper.editPermissionsNavButton()));
            showHelpTip(AJS.$("#permission-helper-button"));
        }
        else if (isOnViewPermissionsPage()) {
            var $opMenu = getOperationMenuOnViewPermissionsPage();
            // operations menu may be hidden
            if ($opMenu.length == 1) {
                $opMenu.prepend($(JIRA.Templates.Nav.PermissionHelper.viewPermissionsNavButton()));
                showHelpTip(AJS.$("#permission-helper-button"));
            }
        }
    });

    function isOnEditPermissionsPage() {
        var $el = $("#edit_project_permissions");
        return ($el.length >= 1);
    }

    function isOnViewPermissionsPage() {
        var $el = $("#project-config-panel-permissions");
        return ($el.length >= 1);
    }

    function getHeaderOnEditPermissionsPage() {
        var $header = $(".content-body > header");
        if ($header.length == 0) {
            $header = $("<header>");
            $(".content-body").prepend($header);
        }
        return $header;
    }

    function getOperationMenuOnViewPermissionsPage() {
        if (AJS.DarkFeatures.isEnabled('com.atlassian.jira.config.PDL')) {
            var pageActionsContainer = $("#project-config-panel-permissions > .aui-page-header .aui-page-header-actions");
            var existingButtons = pageActionsContainer.find(".aui-buttons");
            return (existingButtons.size() > 0) ? existingButtons : pageActionsContainer;
        }
        return $(".project-config-panel-header > .operation-menu");
    }

    function showHelpTip($anchor) {
        if (AJS.HelpTip) {
            var helpTip = new AJS.HelpTip({
                id: 'permission-helper-helptip',
                title: AJS.I18n.getText('permissionhelper.nav.helptip.title'),
                body: AJS.I18n.getText('permissionhelper.nav.helptip.body'),
                anchor: $anchor
            });
            helpTip.show();

            $('#permission-helper-helptip').click(function() {
                helpTip.dismiss();
            });
            $anchor.click(function() {
                helpTip.dismiss();
            })
        }
    }
    
})(AJS.$);
