(function($) {

    var LABEL = AJS.I18n.getText('adminhelper.dialog.notification.title');

    JIRA.NotificationHelper.dialog = new JIRA.NotificationHelper.NotificationHelperDialog;
    $(document).delegate(".notificationhelper-trigger", "click", function(event) {
        event.preventDefault();
        AJS.trigger('analyticsEvent', {name: 'adminhelper.notihelper.dialog.open'});
        JIRA.NotificationHelper.dialog.show(createViewContext());
    });

    $(function () {
        var adminPageContainer = $("#notification-helper-admin-page");
        if (adminPageContainer.length == 1) {
            // Add page header
            addTitleToAdminPage();

            AJS.trigger('analyticsEvent', {name: 'adminhelper.notihelper.adminpage.open'});
            // Add page contents
            adminPageContainer.append($(JIRA.Templates.Dialogs.NotificationHelper.searchPage({
                noCloseLink: true,
                events: JIRA.NotificationHelper.NOTIFICATION_EVENTS,
                defaultEventId: JIRA.NotificationHelper.defaultEventId()

            })));
            adminPageContainer.trigger(JIRA.Events.NEW_CONTENT_ADDED, [adminPageContainer]);
            JIRA.NotificationHelper.NotificationHelperUi.initUi(adminPageContainer, new JIRA.NotificationHelper.Context());

            $("#notificationhelper-user-field").focus();
        }
    });


    function createViewContext() {
        var issueKey = JIRA.Issue.getIssueKey();
        if (!issueKey && JIRA.IssueNavigator) {
            issueKey = JIRA.IssueNavigator.getSelectedIssueKey();
        }
        return new JIRA.NotificationHelper.Context({
            issueKey: issueKey,
            issueOperation: JIRA.NotificationHelper.dialog.OPERATION_VIEW
        });
    }

    function addTitleToAdminPage() {
        var $page = $('#notification-helper-admin-page');
        $page.prepend($("<h2>")
            .attr("id", "admin-page-heading")
            .text(LABEL));
    }

})(AJS.$);
