
/**
 * @constructor
 * @extends JIRA.Dialog
 */
JIRA.NotificationHelper.NotificationHelperDialog = JIRA.Dialog.extend({



    _getDefaultOptions: function () {
        return AJS.$.extend(this._super(), {
            cached: false,
            id: "permission-helper-dialog",
            widthClass: "large",
            stacked: true
        });
    },

    _setContent: function (content, decorate) {
        var instance = this;
        if (content) {
            this._super(content, decorate);
        } else {
            var currentIssueKey = this.context().issueKey() || '';
            this._super(AJS.$(JIRA.Templates.Dialogs.NotificationHelper.searchPage({
                currentIssueKey: currentIssueKey,
                events: JIRA.NotificationHelper.NOTIFICATION_EVENTS,
                defaultEventId: JIRA.NotificationHelper.defaultEventId()
            })), true);
        }
        // init the close link
        this.get$popupContent().find(".cancel").click(function(e) {
            instance.hide();
            e.preventDefault();
        });
        // TODO not sure if applies here
        if (JIRA.Dialog.current === this) {
            var triggerConfig = new JIRA.setFocus.FocusConfiguration();
            triggerConfig.context = this.get$popup()[0];
            triggerConfig.parentElementSelectors = ['.form-body'];
            JIRA.setFocus.pushConfiguration(triggerConfig);
            JIRA.setFocus.triggerFocus();
        }
    },

    decorateContent: function () {

        var self = this;
        this.addHeading(AJS.I18n.getText("adminhelper.dialog.notification.title"));
        JIRA.NotificationHelper.NotificationHelperUi.initUi(this.get$popupContent(), this.context(), function() {
            self._positionInCenter();
        });
    },

    show: function(context) {
        if (context) {
            this.context(context);
        }
        if (!this.options.context) {
            throw "This class must be initialized with 'context' parameter before calling show()";
        }
        this._super();
    },

    context: function(context) {
        if (context) {
            this.options.context = context;
        } else {
            return this.options.context;
        }
    },

    hide: function (undim) {

        if (this._super(undim) === false) {
            return false;
        }
        JIRA.setFocus.popConfiguration();
    }
});

JIRA.NotificationHelper.Context = Class.extend({

    init: function(options) {
        this.options = options || {};
    },

    issueKey: function(issueKey) {
        if (issueKey) {
            this.options.issueKey = issueKey;
        } else {
            return this.options.issueKey;
        }
    },

    eventId: function(eventId) {
        if (eventId) {
            this.options.permissionId = eventId;
        } else {
            return this.options.eventId;
        }
    },

    params: function(overridingParams) {
        var theOptions = AJS.$.extend({}, this.options);
        if (this._exists(overridingParams)) {
            AJS.$.extend(theOptions, overridingParams);
        }
        return theOptions;
    },

    asRequestParams: function(overridingParams) {
        var theOptions = this.params(overridingParams);

        var params = "atl_token=" + atl_token();
        if (this._exists(theOptions.username)) {
            params += "&username=" + theOptions.username;
        }
        if (this._exists(theOptions.issueKey)) {
            params += "&issueKey=" + theOptions.issueKey;
        }
        if (this._exists(theOptions.projectKey)) {
            params += "&projectKey=" + theOptions.projectKey;
        }
        if (this._exists(theOptions.projectId)) {
            params += "&projectId=" + theOptions.projectId;
        }
        if (this._exists(theOptions.issueOperation !== undefined)) {
            params += "&issueOperation=" + theOptions.issueOperation;
        }
        if (this._exists(theOptions.issueTypeId)) {
            params += "&issueTypeId=" + theOptions.issueTypeId;
        }
        return params;
    },

    _exists: function(object) {
        return typeof(object) != 'undefined';
    }

});

