AJS.namespace("JIRA.AdminHelper");

/**
 * A single-select list for selecting Issues.
 *
 * @constructor JIRA.AdminHelper.IssuePicker
 * @extends AJS.SingleSelect
 */
JIRA.AdminHelper.IssuePicker = AJS.SingleSelect.extend({

    init: function (options) {

        function formatResponse(response) {
            if (!response.sections) {
                return [];
            }
            var ret = [];
            AJS.$(response.sections).each(function(i, section) {
                var groupDescriptor = new AJS.GroupDescriptor({
                    weight: i,
                    label: section.label
                });

                AJS.$(section.issues).each(function(i, issue) {
                    groupDescriptor.addItem(new AJS.ItemDescriptor({
                        value: issue.key,
                        label: issue.key + " - "  + issue.summaryText,
                        html: issue.keyHtml + " - " + issue.summary,
                        icon: contextPath + issue.img
                    }));
                });

                ret.push(groupDescriptor);
            });

            return ret;
        }

        AJS.$.extend(options, {
            errorMessage: AJS.I18n.getText("permissionhelper.dialog.issue.missing"),
            ajaxOptions: {
                /* The "project!=null" JQL query forces the search function to actually search the entire space of
                 * issues (as long as they are associated with a project), rather than the default behaviour of only
                 * searching the current user's recently viewed issues history.
                 *
                 * This should be upgraded to rest/api/2/search as a next step.
                 */
                url: contextPath + "/rest/api/1.0/issues/picker?currentJQL=project!=null",
                query: true,
                formatResponse: formatResponse
            }
        });

        this._super(options);
    }
});
