/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permissionhelper.transform;

import com.atlassian.jira.customfieldhelper.rest.PermissionGroupRepresentation;
import com.atlassian.jira.customfieldhelper.rest.PermissionRepresentation;
import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class PermissionsArrayTransformer
implements WebResourceTransformer {
    private static final String PERMISSIONS_SUBSTITUTION = "PERMISSIONS_SUBSTITUTION";
    private static final Pattern PATTERN_REGEX = Pattern.compile("PERMISSIONS_SUBSTITUTION", 16);
    private final I18nResolver i18nResolver;
    private final SchemePermissions schemePermissions;
    private String json;

    public PermissionsArrayTransformer(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.schemePermissions = new SchemePermissions();
    }

    public DownloadableResource transform(Element element, ResourceLocation resourceLocation, String s, DownloadableResource downloadableResource) {
        return new PermissionsInterpolatedResource(downloadableResource);
    }

    private String getPermissionsAsJs() {
        if (this.json == null) {
            ArrayList permissions = Lists.newArrayList();
            for (Permissions.Permission permission : Permissions.Permission.values()) {
                if (permission.getType() == Permissions.Type.GLOBAL) continue;
                permissions.add(new PermissionRepresentation(permission.getId(), this.i18nResolver.getText(permission.getNameKey())));
            }
            PermissionGroupRepresentation projectGroup = new PermissionGroupRepresentation(this.i18nResolver.getText("admin.permission.group.project.permissions"), this.transformPermissions(this.schemePermissions.getProjectPermissions()));
            PermissionGroupRepresentation issueGroup = new PermissionGroupRepresentation(this.i18nResolver.getText("admin.permission.group.issue.permissions"), this.transformPermissions(this.schemePermissions.getIssuePermissions()));
            PermissionGroupRepresentation votersWatchersGroup = new PermissionGroupRepresentation(this.i18nResolver.getText("admin.permission.group.voters.and.watchers.permissions"), this.transformPermissions(this.schemePermissions.getVotersAndWatchersPermissions()));
            PermissionGroupRepresentation commentsGroup = new PermissionGroupRepresentation(this.i18nResolver.getText("admin.permission.group.comments.permissions"), this.transformPermissions(this.schemePermissions.getCommentsPermissions()));
            PermissionGroupRepresentation attachmentsGroup = new PermissionGroupRepresentation(this.i18nResolver.getText("admin.permission.group.attachments.permissions"), this.transformPermissions(this.schemePermissions.getAttachmentsPermissions()));
            PermissionGroupRepresentation timeTrackingGroup = new PermissionGroupRepresentation(this.i18nResolver.getText("admin.permission.group.time.tracking.permissions"), this.transformPermissions(this.schemePermissions.getTimeTrackingPermissions()));
            ArrayList groups = Lists.newArrayList();
            groups.add(projectGroup);
            groups.add(issueGroup);
            groups.add(votersWatchersGroup);
            groups.add(commentsGroup);
            groups.add(attachmentsGroup);
            groups.add(timeTrackingGroup);
            this.json = new JSONArray((Collection)groups).toString();
        }
        return this.json;
    }

    private Iterable<PermissionRepresentation> transformPermissions(Map<Integer, Permission> map) {
        ArrayList projectPermissions = Lists.newArrayList();
        for (Integer key : map.keySet()) {
            projectPermissions.add(new PermissionRepresentation(key, this.i18nResolver.getText(map.get(key).getNameKey())));
        }
        return projectPermissions;
    }

    class PermissionsInterpolatedResource
    extends CharSequenceDownloadableResource {
        public PermissionsInterpolatedResource(DownloadableResource originalResource) {
            super(originalResource);
        }

        protected CharSequence transform(CharSequence original) {
            if (original == null) {
                return null;
            }
            Matcher matcher = PATTERN_REGEX.matcher(original);
            return matcher.replaceAll(PermissionsArrayTransformer.this.getPermissionsAsJs());
        }
    }
}

