/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.context.DefaultPermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.inspector.engine.PermissionInspectionEngine;
import com.atlassian.jira.customfieldhelper.rest.FieldInfoRequestUserValidator;
import com.atlassian.jira.customfieldhelper.rest.InspectorFactory;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestException;
import com.atlassian.jira.customfieldhelper.rest.PermissionInfoJson;
import com.atlassian.jira.customfieldhelper.rest.PermissionRepresentation;
import com.atlassian.jira.customfieldhelper.rest.RestValidationHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.math.NumberUtils;

@Path(value="permissions")
@Produces(value={"application/json"})
public class PermissionsResource {
    private final FieldInfoRequestUserValidator userValidator;
    private final InspectorFactory inspectorFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory requestContextFactory;
    private final PermissionSchemeManager permissionSchemeManager;
    private final RestValidationHelper restValidationHelper;

    public PermissionsResource(FieldInfoRequestUserValidator userValidator, InspectorFactory inspectorFactory, JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory requestContextFactory, PermissionSchemeManager permissionSchemeManager, RestValidationHelper restValidationHelper) {
        this.userValidator = userValidator;
        this.inspectorFactory = inspectorFactory;
        this.authenticationContext = jiraAuthenticationContext;
        this.restValidationHelper = restValidationHelper;
        this.requestContextFactory = requestContextFactory;
        this.permissionSchemeManager = permissionSchemeManager;
    }

    @GET
    public Response getUserInfoForIssue(@QueryParam(value="username") String username, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="permissionId") String permissionId) {
        try {
            this.userValidator.validateAndGet();
            User user = this.restValidationHelper.validateInspectedUser(username);
            Issue issue = this.restValidationHelper.validateIssue(issueKey);
            Project project = issue.getProjectObject();
            Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
            String permissionSchemeName = permissionScheme.getName();
            Permissions.Permission permission = this.getPermissionFromId(NumberUtils.toInt((String)permissionId, (int)10));
            DefaultPermissionInspectionContext realContext = new DefaultPermissionInspectionContext(issue, issue.getProjectObject(), this.requestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl(), user, this.authenticationContext.getI18nHelper(), permissionSchemeName, permission);
            Iterable<InspectionNote> result = new PermissionInspectionEngine((Iterable<? extends ProjectPermissionInspector>)this.inspectorFactory.getPermissionInspectors()).run(realContext);
            return Response.ok((Object)this.createOkResponse(result, realContext)).cacheControl(PermissionsResource.dontCache()).build();
        }
        catch (InvalidRequestException invalidRequest) {
            return invalidRequest.response();
        }
    }

    @GET
    @Path(value="/project")
    public Response getProjectPermissions() {
        ArrayList permissions = Lists.newArrayList();
        for (Permissions.Permission permission : Permissions.Permission.values()) {
            if (permission.getType() == Permissions.Type.GLOBAL) continue;
            permissions.add(new PermissionRepresentation(permission.getId(), this.authenticationContext.getI18nHelper().getText(permission.getNameKey())));
        }
        return Response.ok((Object)permissions).build();
    }

    private Permissions.Permission getPermissionFromId(int id) {
        for (Permissions.Permission permission : Permissions.Permission.values()) {
            if (permission.getId() != id) continue;
            return permission;
        }
        return Permissions.Permission.BROWSE;
    }

    private Object createOkResponse(Iterable<InspectionNote> notes, PermissionInspectionContext context) {
        return PermissionInfoJson.createInfoBean(notes, context);
    }

    private static javax.ws.rs.core.CacheControl dontCache() {
        return CacheControl.never();
    }
}

