/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.context.DefaultFieldInspectionContext;
import com.atlassian.jira.customfieldhelper.rest.FieldInspectionContextFactory;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestException;
import com.atlassian.jira.customfieldhelper.rest.InvalidRequestExceptionFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultFieldInspectionContextFactory
implements FieldInspectionContextFactory {
    private final FieldManager fieldManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final PermissionManager permissionManager;
    private final IssueService issueService;
    private final IssueFactory issueFactory;
    private final ProjectService projectService;
    private final ConstantsManager constantsManager;
    private final VelocityRequestContextFactory requestContextFactory;
    private final InvalidRequestExceptionFactory exceptionFactory;

    @Autowired
    public DefaultFieldInspectionContextFactory(FieldManager fieldManager, I18nHelper.BeanFactory i18nFactory, PermissionManager permissionManager, IssueService issueService, IssueFactory issueFactory, ProjectService projectService, ConstantsManager constantsManager, VelocityRequestContextFactory factory, InvalidRequestExceptionFactory invalidRequestExceptionFactory) {
        this.fieldManager = fieldManager;
        this.i18nFactory = i18nFactory;
        this.permissionManager = permissionManager;
        this.issueService = issueService;
        this.issueFactory = issueFactory;
        this.projectService = projectService;
        this.constantsManager = constantsManager;
        this.requestContextFactory = factory;
        this.exceptionFactory = invalidRequestExceptionFactory;
    }

    @Override
    public FieldInspectionContextFactory.FieldInfoRequest newRequest(User user, String fieldId) {
        if (user == null) {
            throw this.exceptionFactory.failedWithMessage(Response.Status.UNAUTHORIZED, "whereismycf.error.anonymous", new Object[0]);
        }
        if (fieldId == null) {
            throw this.exceptionFactory.failedWithMessage(Response.Status.BAD_REQUEST, "whereismycf.error.paramnotset", "cfId");
        }
        return new RequestImpl(user, fieldId);
    }

    private final class RequestImpl
    implements FieldInspectionContextFactory.FieldInfoRequest {
        private final User user;
        private final String fieldId;
        private String issueKey;
        private String projectKey;
        private Long projectId;
        private String issueTypeId;
        private Long issueOperationId;

        private RequestImpl(User user, String fieldId) {
            this.user = user;
            this.fieldId = fieldId;
        }

        @Override
        public FieldInspectionContextFactory.FieldInfoRequest issueKey(String issueKey) {
            this.issueKey = issueKey;
            return this;
        }

        @Override
        public FieldInspectionContextFactory.FieldInfoRequest projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        @Override
        public FieldInspectionContextFactory.FieldInfoRequest projectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public FieldInspectionContextFactory.FieldInfoRequest issueTypeId(String issueTypeId) {
            this.issueTypeId = issueTypeId;
            return this;
        }

        @Override
        public FieldInspectionContextFactory.FieldInfoRequest issueOperationId(Long issueOperationId) {
            this.issueOperationId = issueOperationId;
            return this;
        }

        @Override
        public FieldInspectionContext getContext() {
            this.validateUser();
            Field field = this.getField();
            Issue issue = this.getIssueFromKey();
            Project project = this.getProject(issue);
            IssueType issueType = this.getIssueType(issue);
            IssueOperation issueOperation = this.getIssueOperationForRequest();
            if (issue == null) {
                issue = this.getNewIssue(project, issueType);
            }
            return new DefaultFieldInspectionContext(field, issue, issueOperation, project, issueType, DefaultFieldInspectionContextFactory.this.requestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl(), this.user, this.i18n());
        }

        private void validateUser() {
            if (this.user == null) {
                throw this.failedWithMessage(Response.Status.UNAUTHORIZED, "whereismycf.error.anonymous", new Object[0]);
            }
            if (!DefaultFieldInspectionContextFactory.this.permissionManager.hasPermission(0, this.user)) {
                throw this.failedWithMessage(Response.Status.UNAUTHORIZED, "whereismycf.error.notanadmin", new Object[0]);
            }
        }

        private Field getField() {
            if (this.fieldId == null) {
                throw this.failedWithMessage(Response.Status.BAD_REQUEST, "whereismycf.error.paramnotset", "cfId");
            }
            Field field = DefaultFieldInspectionContextFactory.this.fieldManager.getField(this.fieldId);
            if (field == null) {
                throw this.failedWithMessage(Response.Status.BAD_REQUEST, "whereismycf.error.cfnotfound", this.fieldId);
            }
            return field;
        }

        private Issue getIssueFromKey() {
            if (this.issueKey != null) {
                IssueService.IssueResult issueResult = DefaultFieldInspectionContextFactory.this.issueService.getIssue(this.user, this.issueKey);
                this.validateServiceResult((ServiceResult)issueResult);
                return issueResult.getIssue();
            }
            return null;
        }

        private Project getProject(Issue issue) {
            if (this.projectKey != null) {
                ProjectService.GetProjectResult projectResult = DefaultFieldInspectionContextFactory.this.projectService.getProjectByKey(this.user, this.projectKey);
                this.validateServiceResult((ServiceResult)projectResult);
                return projectResult.getProject();
            }
            if (this.projectId != null) {
                ProjectService.GetProjectResult projectResult = DefaultFieldInspectionContextFactory.this.projectService.getProjectById(this.user, this.projectId);
                this.validateServiceResult((ServiceResult)projectResult);
                return projectResult.getProject();
            }
            if (issue == null) {
                throw this.failedWithMessage(Response.Status.BAD_REQUEST, "whereismycf.error.paramnotset3", "issueKey", "projectKey", "projectId");
            }
            return issue.getProjectObject();
        }

        private IssueType getIssueType(Issue issue) {
            if (this.issueTypeId != null) {
                IssueType issueType = DefaultFieldInspectionContextFactory.this.constantsManager.getIssueTypeObject(this.issueTypeId);
                if (issueType == null) {
                    throw this.failedWithMessage(Response.Status.BAD_REQUEST, "whereismycf.error.issuetypeunknown", this.issueTypeId);
                }
                return issueType;
            }
            if (issue == null) {
                throw this.failedWithMessage(Response.Status.BAD_REQUEST, "whereismycf.error.paramnotset2", "issueKey", "issueTypeId");
            }
            return issue.getIssueTypeObject();
        }

        private IssueOperation getIssueOperationForRequest() {
            ScreenableIssueOperation issueOperation = IssueOperations.getIssueOperation((Long)this.issueOperationId);
            if (issueOperation == null) {
                throw this.failedWithMessage(Response.Status.BAD_REQUEST, "whereismycf.error.issueopunknown", this.issueOperationId);
            }
            return issueOperation;
        }

        private Issue getNewIssue(Project project, IssueType issueType) {
            MutableIssue newIssue = DefaultFieldInspectionContextFactory.this.issueFactory.getIssue();
            newIssue.setProjectObject(project);
            newIssue.setIssueTypeObject(issueType);
            return newIssue;
        }

        private void validateServiceResult(ServiceResult serviceResult) {
            if (!serviceResult.isValid()) {
                ErrorCollection restErrors = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)serviceResult.getErrorCollection());
                throw DefaultFieldInspectionContextFactory.this.exceptionFactory.failed(Response.status((int)restErrors.getStatus()).entity((Object)restErrors).build());
            }
        }

        private InvalidRequestException failedWithMessage(Response.Status status, String msgKey, Object ... params) {
            return DefaultFieldInspectionContextFactory.this.exceptionFactory.failedWithMessage(this.i18n(), status, msgKey, params);
        }

        private I18nHelper i18n() {
            return DefaultFieldInspectionContextFactory.this.i18nFactory.getInstance(this.user);
        }
    }
}

