/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeInspector;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SchemeUserCustomFieldInspector
implements SchemeInspector {
    private final CustomFieldManager customFieldManager;

    public SchemeUserCustomFieldInspector(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    @Override
    public InspectionNote inspect(SchemeEntity schemeEntity, InspectionContext context) {
        if (context.isAnonymous()) {
            return InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.anonymous.cannot.meet")).build();
        }
        String customFieldId = schemeEntity.getParameter();
        CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldId);
        if (customField != null) {
            Collection<ApplicationUser> users = this.getUsers(context.issue().getCustomFieldValue(customField));
            if (users.contains(ApplicationUsers.from((User)context.user()))) {
                return InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.cfuser.ok").addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(customField.getName()).build()).build();
            }
            return InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.cfuser.problem").addPlainParameter(UserHelper.getDisplayName(context)).addPlainParameter(customField.getName()).build()).build();
        }
        return null;
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.cfuser.summary");
    }

    private Collection<ApplicationUser> getUsers(Object customFieldValue) {
        if (customFieldValue == null) {
            return Collections.emptyList();
        }
        if (customFieldValue instanceof ApplicationUser) {
            return Arrays.asList((ApplicationUser)customFieldValue);
        }
        if (customFieldValue instanceof Collection) {
            Collection collection = (Collection)customFieldValue;
            ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>(collection.size());
            for (Object obj : collection) {
                if (!(obj instanceof ApplicationUser)) continue;
                users.add((ApplicationUser)obj);
            }
            return users;
        }
        return Collections.emptyList();
    }
}

