/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.scheme;

import com.atlassian.jira.customfieldhelper.api.InspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeInspector;
import com.atlassian.jira.customfieldhelper.util.UserHelper;
import com.atlassian.jira.scheme.SchemeEntity;
import com.google.common.base.Objects;

public class SchemeLeadInspector
implements SchemeInspector {
    public static final SchemeLeadInspector INSTANCE = new SchemeLeadInspector();

    @Override
    public InspectionNote inspect(SchemeEntity schemeEntity, InspectionContext context) {
        if (context.isAnonymous()) {
            return InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.anonymous.cannot.meet")).build();
        }
        if (Objects.equal((Object)context.user(), (Object)context.project().getLead())) {
            return InspectionNote.ok(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.lead.ok").addPlainParameter(UserHelper.getDisplayName(context)).build()).build();
        }
        InspectionNote.Builder problemBuilder = InspectionNote.problem(this.summary(context)).addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.lead.problem").addPlainParameter(UserHelper.getDisplayName(context)).build());
        if (!context.isAnonymous()) {
            problemBuilder.addDetails(InspectionMessageBuilder.forContext(context).templateKey("permissionhelper.inspection.viewissue.lead.problem.fix").newI18nLinkParameter().pathKey("whereismycf.inspection.link.projectpeople").urlParams(context.project().getKey()).textKey("permissionhelper.inspection.viewissue.lead.problem.linktext.projectpeople").textParams(context.project().getName()).add().addPlainParameter(UserHelper.getDisplayName(context)).build());
        }
        return problemBuilder.build();
    }

    private InspectionMessage summary(InspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "permissionhelper.inspection.viewissue.lead.summary");
    }
}

