/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.permission;

import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.api.PermissionInspectionContext;
import com.atlassian.jira.customfieldhelper.api.ProjectPermissionInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeReporterInspector;
import com.atlassian.jira.customfieldhelper.impl.inspector.scheme.SchemeTypes;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.Scheme;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionSchemeReporterInspector
implements ProjectPermissionInspector {
    private final PermissionSchemeManager permissionSchemeManager;

    @Autowired
    public PermissionSchemeReporterInspector(PermissionSchemeManager permissionSchemeManager) {
        this.permissionSchemeManager = permissionSchemeManager;
    }

    @Override
    public Iterable<InspectionNote> inspect(PermissionInspectionContext context) {
        Project project = context.project();
        Scheme permissionScheme = this.permissionSchemeManager.getSchemeFor(project);
        List entities = permissionScheme.getEntitiesByType((Object)context.permission().getId());
        return SchemeTypes.forEach(entities, context, "reporter", SchemeReporterInspector.INSTANCE);
    }
}

