/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.inspector.field;

import com.atlassian.jira.customfieldhelper.api.FieldInspectionContext;
import com.atlassian.jira.customfieldhelper.api.InspectionMessage;
import com.atlassian.jira.customfieldhelper.api.InspectionMessageBuilder;
import com.atlassian.jira.customfieldhelper.api.InspectionNote;
import com.atlassian.jira.customfieldhelper.impl.inspector.field.AbstractFieldInspector;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nonnull;

public class ImmutableSystemFieldInspector<F extends Field>
extends AbstractFieldInspector<F> {
    private final Iterable<IssueOperation> supportedOperations;
    private final Iterable<IssueOperation> excludedOperations;
    private final boolean supportsAll;

    public static <G extends Field> ImmutableSystemFieldInspector<G> forFieldType(Class<G> fieldType) {
        return new ImmutableSystemFieldInspector<G>(fieldType, null, null, true);
    }

    public static <G extends Field> ImmutableSystemFieldInspector<G> forFieldTypeAndSupportedOps(Class<G> fieldType, IssueOperation ... supportedOps) {
        return new ImmutableSystemFieldInspector<G>(fieldType, (Iterable<IssueOperation>)ImmutableList.copyOf((Object[])supportedOps), null, false);
    }

    public static <G extends Field> ImmutableSystemFieldInspector<G> forFieldTypeAndExcludedOps(Class<G> fieldType, IssueOperation ... supportedOps) {
        return new ImmutableSystemFieldInspector<G>(fieldType, null, (Iterable<IssueOperation>)ImmutableList.copyOf((Object[])supportedOps), false);
    }

    private ImmutableSystemFieldInspector(Class<F> supportedType, Iterable<IssueOperation> supportedOperations, Iterable<IssueOperation> excludedOperations, boolean supportsAll) {
        super(supportedType);
        this.supportedOperations = supportedOperations;
        this.excludedOperations = excludedOperations;
        this.supportsAll = supportsAll;
    }

    @Override
    @Nonnull
    public Iterable<InspectionNote> inspect(F field, FieldInspectionContext context) {
        if (!this.supports(context)) {
            return Collections.emptyList();
        }
        context.excludeAll();
        if (context.issueOperation() == IssueOperations.VIEW_ISSUE_OPERATION) {
            return ImmutableList.of((Object)this.createViewNote(field, context));
        }
        return ImmutableList.of((Object)this.createEditNote(field, context));
    }

    private boolean supports(FieldInspectionContext context) {
        if (this.supportsAll) {
            return true;
        }
        if (this.supportedOperations != null && !Iterables.contains(this.supportedOperations, (Object)context.issueOperation())) {
            return false;
        }
        return this.excludedOperations == null || !Iterables.contains(this.excludedOperations, (Object)context.issueOperation());
    }

    private InspectionNote createViewNote(F field, FieldInspectionContext context) {
        return InspectionNote.ok().addSummary(this.createSummary(field, context)).addDetails(this.createViewDetails(field, context)).build();
    }

    private InspectionNote createEditNote(F field, FieldInspectionContext context) {
        return InspectionNote.problem().addSummary(this.createSummary(field, context)).addDetails(this.createEditDetails(field, context)).build();
    }

    private InspectionMessage createSummary(F field, FieldInspectionContext context) {
        return InspectionMessageBuilder.forContext(context).templateKey("whereismycf.inspection.immutable.summary").addPlainParameter(field.getName()).build();
    }

    private InspectionMessage createViewDetails(F field, FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.immutable.view");
    }

    private InspectionMessage createEditDetails(F field, FieldInspectionContext context) {
        return InspectionMessageBuilder.newSimpleMessage(context, "whereismycf.inspection.immutable.edit");
    }
}

