/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.customfieldhelper.impl.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.customfieldhelper.api.NotificationInspectionContext;
import com.atlassian.jira.customfieldhelper.impl.context.DefaultInspectionContext;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Preconditions;

public class DefaultNotificationInspectionContext
extends DefaultInspectionContext
implements NotificationInspectionContext {
    private final EventType eventType;
    private final Scheme scheme;
    private final Boolean notifyOwnChanges;
    private final User loggedInUser;

    public DefaultNotificationInspectionContext(EventType eventType, Scheme scheme, Issue issue, String baseUrl, User user, Boolean notifyOwnChanges, I18nHelper i18nHelper, User loggedInUser) {
        super(issue, null, issue.getProjectObject(), issue.getIssueTypeObject(), baseUrl, user, i18nHelper);
        this.eventType = (EventType)Preconditions.checkNotNull((Object)eventType, (Object)"eventType");
        this.scheme = scheme;
        this.notifyOwnChanges = notifyOwnChanges;
        this.loggedInUser = loggedInUser;
    }

    @Override
    public EventType eventType() {
        return this.eventType;
    }

    @Override
    public String eventTypeName() {
        return this.eventType().getTranslatedName(this.loggedInUser);
    }

    @Override
    public Scheme notificationScheme() {
        return this.scheme;
    }

    @Override
    public Boolean notifyOwnChanges() {
        return this.notifyOwnChanges;
    }
}

