define('jira/inline-issue-create/util', [
    'jira/util/logger',
    'underscore',
    'jquery'
], function (
    logger,
    _,
    $
) {
    "use strict";

    var bodyStyle = (document.body || document.documentElement).style;
    var eventNames = ["oAnimationEnd", "MSAnimationEnd", "mozAnimationEnd", "webkitAnimationEnd", "animationend"];

    var logFilter;

    return {
        cssAnimationsSupport: bodyStyle.transition !== undefined || bodyStyle.WebkitTransition !== undefined || bodyStyle.MozTransition !== undefined || bodyStyle.MsTransition !== undefined || bodyStyle.OTransition !== undefined,
        addClassAndRemoveOnAnimationEnd: function addClassAndRemoveOnAnimationEnd(el, className, durationInMilis) {
            var i;
            el = $(el);

            function listener() {
                for (i = 0; i < eventNames.length; i++) {
                    el.off(eventNames[i], listener);
                }
                el.removeClass(className);
            }

            if (this.cssAnimationsSupport) {
                for (i = 0; i < eventNames.length; i++) {
                    el.on(eventNames[i], listener);
                }
            } else {
                setTimeout(function() {
                    el.removeClass(className);
                }, durationInMilis || 1000);
            }
            el.addClass(className);
        },
        scrollElementToView: function scrollElementToView($scrollingContainer, $element) {
            var viewportRect = $scrollingContainer[0].getBoundingClientRect();
            var elementRect = $element[0].getBoundingClientRect();

            var containerScrollTop = $scrollingContainer.scrollTop();
            var scrollOffset = 0;
            if (elementRect.top < viewportRect.top) {
                // the element is before the view port begining
                scrollOffset = elementRect.top - viewportRect.top;
            } else if (viewportRect.bottom < elementRect.bottom) {
                // the element is after the view port ending
                scrollOffset = elementRect.bottom - viewportRect.bottom;
            }

            if (scrollOffset !== 0) {
                $scrollingContainer.scrollTop(containerScrollTop + scrollOffset);
            }
        },
        keyCode: {
            ENTER: 13,
            ESC: 27
        },
        after: function after(object, method, body) {
            if (!_.isFunction(body)) {
                throw "Body is not a function";
            }
            object[method] = _.wrap(object[method], function wrapper(originalFunction) {
                var originalArguments = Array.prototype.slice.call(arguments, 1);
                var result = originalFunction.apply(object, originalArguments);
                body.apply(this, _.union([result], originalArguments));
                return result;
            });
        },
        /**
         *
         * @param object
         * @param {...*} message
         */
        error: function error(object) {
            var args = Array.prototype.slice.call(arguments, 1);
            if (_.isString(args[0])) {
                args[0] = "[IIC]" + args[0];
            }
            logger.error.apply(logger, args);
        },
        /**
         *
         * @param object
         * @param {...*} message
         */
        debug: function debug(object) {
            if(this.shouldDisplay(object)){
                var args = Array.prototype.slice.call(arguments, 1);
                if (_.isString(args[0])) {
                    args[0] = "[IIC]" + args[0];
                }
                logger.debug.apply(logger, args);
            }
        },
        /**
         * @param object
         * @param {...*} message
         */
        trace: function trace(object) {
            if(this.shouldDisplay(object)){
                var args = Array.prototype.slice.call(arguments, 1);
                if (_.isString(args[0])) {
                    args[0] = "[IIC]" + args[0];
                }
                logger.debug.apply(logger, args);
            }
        },
        shouldDisplay: function(object) {
            if(logFilter === "all" || object === logFilter) {
                return true;
            }
            return false;
        },
        showLogsFor: function showLogsFor(object) {
            logFilter = object;
        }
    };
});
