define('jira/inline-issue-create/views/issue-type-dropdown', [
    'jira/util/formatter',
    'underscore',
    'jquery',
    'jira/inline-issue-create/lib/marionette',
    'jira/inline-issue-create/views/issue-type-dropdown-item'
], function (
    formatter,
    _,
    $,
    Marionette,
    IssueTypeDropdownItemView
) {
    "use strict";

    var IssueTypesDropdown = Marionette.CompositeView.extend({
        childView: IssueTypeDropdownItemView,
        childViewOptions: function itemViewOptions(model, index) {
            return {
                model: model,
                dropdownModel: this.model
            };
        },
        template: JIRA.Templates.InlineIssueCreate.issueTypeSelector,
        childViewContainer: ".aui-list-truncate",
        ui: {
            trigger: '.iic-widget__issue-type-selector__trigger',
            issueTypeIcon: '.iic-widget__issue-type-selector__trigger img',
            issueTypeDropdown: '.iic-widget__issue-type-selector__dropdown'
        },
        modelEvents: {
            "change:selectedIssueType": function onSelectedIssueTypeChange() {
                if (this.model.getSelectedIssueType()) {
                    this.ui.issueTypeIcon.attr("src", this.model.getSelectedIssueType().getIconUrl());
                    this.ui.issueTypeIcon.attr("alt", this.model.getSelectedIssueType().getName());
                }
            },
            "change:lockState": function onLockStateChange(m, state) {
                this.render();
                if (state === this.model.constants.STATE_LOCK_SENDING) {
                    this.ui.trigger.attr("aria-disabled", true);
                } else {
                    this.ui.trigger.attr("aria-disabled", false);
                }
            }
        },
        initialize: function initialize() {
            this.isDropdownShown = false;
            _.bindAll(this, 'onDropdownShow');
        },
        serializeData: function serializeData() {
            var data = {};
            if (this.model.getSelectedIssueType()) {
                data = this.model.getSelectedIssueType().toJSON();
            }

            return {
                widgetId: this.options.widgetId,
                isLocked: this.model.getLockState() !== this.model.constants.STATE_LOCK_UNLOCKED,
                issueTypeIconUrl: data.iconUrl,
                issueTypeName: data.name || formatter.I18n.getText('iic.issuetype.locked')
            };
        },
        onRender: function onRender() {
            this.unwrapTemplate();
            this.ui.issueTypeDropdown.on("aui-dropdown2-show", this.onDropdownShow);
        },
        // SW-3720: this has no effect in AUI 5.9.17; AUI just re-re-positions the dropdown menu after
        onDropdownShow: function onDropdownShow() {
            // we don't want dropdown to be attached to body so we put it back where it was
            // necessary to get the dropdown menu to move with page scroll
            var $dropdown = this.ui.issueTypeDropdown;
            $dropdown.appendTo(this.$el);

            var triggerOffset = this.ui.issueTypeIcon.offset();
            var triggerPosition = this.ui.issueTypeIcon.position();
            var triggerHeight = this.ui.issueTypeIcon.outerHeight();
            var dropdownHeight = $dropdown.height();
            var isDropdownMenuBelowPage = $("body").outerHeight(true) < triggerOffset.top + triggerHeight + dropdownHeight;
            $dropdown.css({
                left: triggerPosition.left,
                top: (isDropdownMenuBelowPage ? triggerPosition.top - dropdownHeight : triggerPosition.top + triggerHeight) + "px"
            });
        },
        onChildviewSelected: function onChildviewSelected(itemView) {
            this.trigger("issueTypeSelected", itemView.model);
        }
    });

    return IssueTypesDropdown;
});
