define('jira/inline-issue-create/agile/issue-type-dropdown', [
    'jquery',
    'jira/inline-issue-create/util',
    'jira/inline-issue-create/views/issue-type-dropdown'
], function (
    $,
    U,
    IssueTypesDropdown
    ) {
    "use strict";

    return IssueTypesDropdown.extend({
        calculateDropdownDirectionAndHeightPosition: function calculateDropdownDirectionAndHeightPosition(){
            var triggerHeight = this.ui.issueTypeIcon.outerHeight();
            var triggerPosition = this.ui.issueTypeIcon.offset().top;
            var dropdownContentHeight = this.ui.issueTypeDropdown.outerHeight();
            var backlogPosition = $("#ghx-backlog").offset().top;
            var visibleSpaceAbove = triggerPosition - backlogPosition;
            var spaceBelow = $("body").outerHeight(true) - (triggerPosition + triggerHeight);
            U.trace(this, "spaceBelow", spaceBelow, "visibleSpaceAbove", visibleSpaceAbove, "dropdownContentHeight", dropdownContentHeight);
            if (spaceBelow > dropdownContentHeight) {
                U.debug(this, "Positioning down - full");
                return {
                    vAlignment: "bottom"
                };
            } else if(visibleSpaceAbove > dropdownContentHeight) {
                U.debug(this, "Positioning up - full");
                return {
                    vAlignment: "top"
                };
            } else {
                if(spaceBelow > visibleSpaceAbove){
                    U.debug(this, "Positioning down - limited", spaceBelow);
                    return {
                        vAlignment: "bottom",
                        limitHeight: spaceBelow - 10
                    };
                } else {
                    U.debug(this, "Positioning up - limited", visibleSpaceAbove);
                    return {
                        vAlignment: "top",
                        limitHeight: visibleSpaceAbove - 10
                    };
                }
            }
        }
    });
});
