/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.performance;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.inform.api.events.MailLoggerFactory;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorker;
import com.atlassian.jira.plugins.inform.performance.events.PerformanceEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class MeasurementWorkerFactory {
    private static final Logger logger = MailLoggerFactory.getOutgoingMailLogger(MeasurementWorkerFactory.class);
    private EventPublisher eventPublisher;

    @Autowired
    public MeasurementWorkerFactory(@ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public MeasurementWorker<AnalyticParams> ofType(final PerformanceEvent.Type type) {
        return new MeasurementWorker<AnalyticParams>(){

            @Override
            public <T> T measure(Function<AnalyticParams, T> function) {
                boolean error = false;
                AnalyticParams additionalParameters = new AnalyticParams();
                Stopwatch stopwatch = Stopwatch.createStarted();
                try {
                    T t = function.apply(additionalParameters);
                    return t;
                }
                catch (Exception e) {
                    logger.error("Exception occured", (Throwable)e);
                    error = true;
                    throw e;
                }
                finally {
                    stopwatch.stop();
                    if (additionalParameters.shouldBeSent()) {
                        this.publishEvent(error, additionalParameters.getParams(), stopwatch);
                    }
                }
            }

            private void publishEvent(boolean error, Map<String, Object> additionalParameters, Stopwatch stopwatch) {
                HashMap<String, Object> params = new HashMap<String, Object>(additionalParameters);
                PerformanceEvent performanceEvent = new PerformanceEvent(type, stopwatch.elapsed(TimeUnit.MILLISECONDS), !error, params);
                logger.debug(performanceEvent.toString());
                MeasurementWorkerFactory.this.eventPublisher.publish((Object)performanceEvent);
            }
        };
    }

    public static class AnalyticParams {
        private final Map<String, Number> triggeringParams = new HashMap<String, Number>();
        private final Map<String, Object> notTriggeringParams = new HashMap<String, Object>();

        public boolean shouldBeSent() {
            return !this.triggeringParams.isEmpty();
        }

        public Map<String, Object> getParams() {
            return ImmutableMap.builder().putAll(this.triggeringParams).putAll(this.notTriggeringParams).build();
        }

        public AnalyticParams put(String key, long value) {
            if (value > 0L) {
                this.triggeringParams.put(Objects.requireNonNull(key), value);
            }
            return this;
        }

        public AnalyticParams put(String key, int value) {
            return this.put(key, (long)value);
        }

        public AnalyticParams put(String key, double value) {
            if (value > 0.0) {
                this.triggeringParams.put(Objects.requireNonNull(key), value);
            }
            return this;
        }

        public AnalyticParams putNonTriggering(String key, long value) {
            if (value > 0L) {
                this.notTriggeringParams.put(Objects.requireNonNull(key), value);
            }
            return this;
        }

        public AnalyticParams putNonTriggering(String key, int value) {
            return this.putNonTriggering(key, (long)value);
        }

        public AnalyticParams putNonTriggering(String key, double value) {
            if (value > 0.0) {
                this.notTriggeringParams.put(Objects.requireNonNull(key), value);
            }
            return this;
        }

        public AnalyticParams putNonTriggering(String key, String value) {
            this.notTriggeringParams.put(Objects.requireNonNull(key), Objects.requireNonNull(value));
            return this;
        }
    }
}

