/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.managers;

import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.plugins.inform.api.events.Event;
import com.atlassian.jira.plugins.inform.api.events.EventSearchParams;
import com.atlassian.jira.plugins.inform.api.events.EventStatus;
import com.atlassian.jira.plugins.inform.api.events.Parameter;
import com.atlassian.jira.plugins.inform.api.events.Recipient;
import com.atlassian.jira.plugins.inform.api.events.UpdateStatusParams;
import com.atlassian.jira.plugins.inform.api.events.dto.EventDTO;
import com.atlassian.jira.plugins.inform.api.events.dto.ParameterDTO;
import com.atlassian.jira.plugins.inform.api.events.dto.RecipientDTO;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.jira.plugins.inform.events.managers.EventSearcher;
import com.atlassian.jira.plugins.inform.events.mapping.querydsl.Tables;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class EventManagerImpl
implements EventManager {
    private static final Logger logger = LoggerFactory.getLogger(EventManagerImpl.class);
    public static final int MAX_SQL_PARAMETERS = 2000;
    public static final String MAIL_BATCHING_CLEANUP_JOB_BATCH_SIZE_PROPERTY = "mail.batching.cleanup.job.batch.size";
    public static final long MIN_BATCH_SIZE = 1L;
    private final DatabaseAccessor databaseAccessor;
    private final com.atlassian.jira.database.DatabaseAccessor jiraDatabaseAccessor;
    private final EventSearcher eventSearcher = new EventSearcher();

    @Autowired
    public EventManagerImpl(DatabaseAccessor databaseAccessor, @ComponentImport com.atlassian.jira.database.DatabaseAccessor jiraDatabaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.jiraDatabaseAccessor = jiraDatabaseAccessor;
    }

    public Event add(Event event) {
        return (Event)this.databaseAccessor.runInTransaction(dbConnection -> {
            Collection recipients;
            Collection parameters;
            Long eventId = (Long)dbConnection.insert((RelationalPath)Tables.EVENT).set(Tables.EVENT.CREATED, (Object)Timestamp.from(event.getCreated())).set(Tables.EVENT.EVENT_TYPE, (Object)event.getEventType()).set((Path)Tables.EVENT.USER_KEY, (Object)event.getUserKey()).set((Path)Tables.EVENT.ACTION, (Object)event.getAction()).set((Path)Tables.EVENT.ACTION_ID, (Object)event.getActionId()).set((Path)Tables.EVENT.EVENT_BUNDLE_ID, (Object)event.getEventBundleId()).executeWithKey(Tables.EVENT.ID);
            if (this.useBatchInserts()) {
                parameters = this.saveParameters((DatabaseConnection)dbConnection, eventId, event.getParameters());
                recipients = this.saveRecipients((DatabaseConnection)dbConnection, eventId, event.getRecipients());
            } else {
                parameters = event.getParameters().stream().map(param -> this.saveParameter((DatabaseConnection)dbConnection, eventId, param.getName(), param.getValue())).collect(Collectors.toList());
                recipients = event.getRecipients().stream().map(r -> this.saveRecipient((DatabaseConnection)dbConnection, eventId, (Recipient)r)).collect(Collectors.toList());
            }
            return EventDTO.builder().id(eventId).eventType(event.getEventType()).created(event.getCreated()).userKey(event.getUserKey()).action(event.getAction()).actionId(event.getActionId()).eventBundleId(event.getEventBundleId()).parameters(parameters).recipients(recipients).build();
        }, OnRollback.NOOP);
    }

    private boolean useBatchInserts() {
        DatabaseVendor dbVendor = this.jiraDatabaseAccessor.getDatabaseVendor();
        return dbVendor == DatabaseVendor.POSTGRES || dbVendor == DatabaseVendor.MY_SQL || dbVendor == DatabaseVendor.ORACLE;
    }

    private Parameter saveParameter(DatabaseConnection dbConnection, long eventId, String name, String value) {
        Long eventParameterId = (Long)dbConnection.insert((RelationalPath)Tables.EVENT_PARAMETER).set((Path)Tables.EVENT_PARAMETER.NAME, (Object)name).set((Path)Tables.EVENT_PARAMETER.VALUE, (Object)value).set(Tables.EVENT_PARAMETER.EVENT_ID, (Object)eventId).executeWithKey(Tables.EVENT_PARAMETER.ID);
        return new ParameterDTO(eventParameterId, name, value);
    }

    private Collection<Parameter> saveParameters(DatabaseConnection dbConnection, long eventId, Collection<Parameter> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            SQLInsertClause insert = dbConnection.insert((RelationalPath)Tables.EVENT_PARAMETER);
            parameters.forEach(p -> insert.set((Path)Tables.EVENT_PARAMETER.NAME, (Object)p.getName()).set((Path)Tables.EVENT_PARAMETER.VALUE, (Object)p.getValue()).set(Tables.EVENT_PARAMETER.EVENT_ID, (Object)eventId).addBatch());
            List keys = insert.executeWithKeys(Tables.EVENT_PARAMETER.ID);
            if (keys.size() < parameters.size()) {
                logger.warn("key size is lower than parameters size {} < {}, fetching all parameters for {}", new Object[]{keys.size(), parameters.size(), eventId});
                return ((SQLQuery)((SQLQuery)dbConnection.select(new Expression[]{Tables.EVENT_PARAMETER.ID, Tables.EVENT_PARAMETER.EVENT_ID, Tables.EVENT_PARAMETER.NAME, Tables.EVENT_PARAMETER.VALUE}).from((Expression)Tables.EVENT_PARAMETER)).where((Predicate)Tables.EVENT_PARAMETER.EVENT_ID.eq((Object)eventId))).fetch().stream().map(this::toParameter).collect(Collectors.toList());
            }
            ArrayList<Parameter> ret = new ArrayList<Parameter>();
            int idx = 0;
            for (Parameter p2 : parameters) {
                ret.add((Parameter)new ParameterDTO((Long)keys.get(idx), p2.getName(), p2.getValue()));
                ++idx;
            }
            return ret;
        }
        return ImmutableList.of();
    }

    private Recipient saveRecipient(DatabaseConnection dbConnection, long eventId, Recipient r) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("EVENT_ID", eventId);
        parameterMap.put("USER_KEY", r.getUserKey());
        parameterMap.put("CONSUMER_NAME", r.getConsumerName());
        parameterMap.put("STATUS", r.getStatus().toString());
        parameterMap.put("CREATED", this.toTimestamp(r.getCreated()));
        parameterMap.put("UPDATED", this.toTimestamp(r.getUpdated()));
        parameterMap.put("SEND_DATE", this.toTimestamp(r.getSendDate()));
        Long eventRecipientId = (Long)dbConnection.insert((RelationalPath)Tables.EVENT_RECIPIENT).set((Path)Tables.EVENT_RECIPIENT.USER_KEY, (Object)r.getUserKey()).set((Path)Tables.EVENT_RECIPIENT.CONSUMER_NAME, (Object)r.getConsumerName()).set((Path)Tables.EVENT_RECIPIENT.STATUS, (Object)r.getStatus().toString()).set(Tables.EVENT_RECIPIENT.CREATED, (Object)this.toTimestamp(r.getCreated())).set(Tables.EVENT_RECIPIENT.UPDATED, (Object)this.toTimestamp(r.getUpdated())).set(Tables.EVENT_RECIPIENT.SEND_DATE, (Object)this.toTimestamp(r.getSendDate())).set(Tables.EVENT_RECIPIENT.EVENT_ID, (Object)eventId).executeWithKey(Tables.EVENT_RECIPIENT.ID);
        return new RecipientDTO(eventRecipientId, r.getUserKey(), r.getConsumerName(), r.getStatus(), r.getCreated(), r.getUpdated(), r.getSendDate());
    }

    private Collection<Recipient> saveRecipients(DatabaseConnection dbConnection, long eventId, Collection<Recipient> recipients) {
        if (recipients != null && !recipients.isEmpty()) {
            SQLInsertClause insert = dbConnection.insert((RelationalPath)Tables.EVENT_RECIPIENT);
            recipients.forEach(r -> insert.set((Path)Tables.EVENT_RECIPIENT.USER_KEY, (Object)r.getUserKey()).set((Path)Tables.EVENT_RECIPIENT.CONSUMER_NAME, (Object)r.getConsumerName()).set((Path)Tables.EVENT_RECIPIENT.STATUS, (Object)r.getStatus().toString()).set(Tables.EVENT_RECIPIENT.CREATED, (Object)this.toTimestamp(r.getCreated())).set(Tables.EVENT_RECIPIENT.UPDATED, (Object)this.toTimestamp(r.getUpdated())).set(Tables.EVENT_RECIPIENT.SEND_DATE, (Object)this.toTimestamp(r.getSendDate())).set(Tables.EVENT_RECIPIENT.EVENT_ID, (Object)eventId).addBatch());
            List keys = insert.executeWithKeys(Tables.EVENT_RECIPIENT.ID);
            if (keys.size() < recipients.size()) {
                logger.warn("key size is lower than recipients size {} < {}, fetching all recipients for {}", new Object[]{keys.size(), recipients.size(), eventId});
                return ((SQLQuery)((SQLQuery)dbConnection.select(new Expression[]{Tables.EVENT_RECIPIENT.ID, Tables.EVENT_RECIPIENT.EVENT_ID, Tables.EVENT_RECIPIENT.USER_KEY, Tables.EVENT_RECIPIENT.CONSUMER_NAME, Tables.EVENT_RECIPIENT.STATUS, Tables.EVENT_RECIPIENT.CREATED, Tables.EVENT_RECIPIENT.UPDATED, Tables.EVENT_RECIPIENT.SEND_DATE}).from((Expression)Tables.EVENT_RECIPIENT)).where((Predicate)Tables.EVENT_RECIPIENT.EVENT_ID.eq((Object)eventId))).fetch().stream().map(this::toRecipient).collect(Collectors.toList());
            }
            ArrayList<Recipient> ret = new ArrayList<Recipient>();
            int idx = 0;
            for (Recipient r2 : recipients) {
                ret.add((Recipient)new RecipientDTO((Long)keys.get(idx), r2.getUserKey(), r2.getConsumerName(), r2.getStatus(), r2.getCreated(), r2.getUpdated(), r2.getSendDate()));
                ++idx;
            }
            return ret;
        }
        return ImmutableList.of();
    }

    public Collection<Event> search(EventSearchParams eventSearchParams) {
        Expression[] eventColumns = new Expression[]{Tables.EVENT.ID, Tables.EVENT.EVENT_TYPE, Tables.EVENT.USER_KEY, Tables.EVENT.ACTION, Tables.EVENT.ACTION_ID, Tables.EVENT.EVENT_BUNDLE_ID, Tables.EVENT.CREATED};
        return (Collection)this.databaseAccessor.runInTransaction(dbConnection -> {
            SQLQuery query = (SQLQuery)dbConnection.select(eventColumns).from((Expression)Tables.EVENT);
            List<Predicate> predicates = this.eventSearcher.predicates(eventSearchParams);
            if (!predicates.isEmpty()) {
                Predicate where = ExpressionUtils.allOf((Predicate[])predicates.toArray(new Predicate[0]));
                query = (SQLQuery)query.where(where);
            }
            if (eventSearchParams.getOrderBy().isEmpty()) {
                query = (SQLQuery)query.orderBy(Tables.EVENT.ID.asc());
            } else {
                for (EventSearchParams.OrderBy orderBy : eventSearchParams.getOrderBy()) {
                    query = (SQLQuery)query.orderBy(orderBy.isAsc() ? EventManagerImpl.orderableField(orderBy.getField()).asc() : EventManagerImpl.orderableField(orderBy.getField()).desc());
                }
            }
            if (eventSearchParams.getLimit() != null) {
                query = (SQLQuery)query.limit(eventSearchParams.getLimit().longValue());
            }
            return query.fetch().stream().map(e -> this.toEvent((Tuple)e, eventSearchParams)).collect(Collectors.toList());
        }, OnRollback.NOOP);
    }

    public long count(EventSearchParams eventSearchParams) {
        return (Long)this.databaseAccessor.runInTransaction(dbConnection -> {
            SQLQuery query = (SQLQuery)dbConnection.select((Expression)Tables.EVENT.ID.count()).from((Expression)Tables.EVENT);
            List<Predicate> predicates = this.eventSearcher.predicates(eventSearchParams);
            if (!predicates.isEmpty()) {
                Predicate where = ExpressionUtils.allOf((Predicate[])predicates.toArray(new Predicate[0]));
                query = (SQLQuery)query.where(where);
            }
            return query.fetchCount();
        }, OnRollback.NOOP);
    }

    private Event toEvent(Tuple from, @Nullable EventSearchParams eventSearchParams) {
        Long id = (Long)from.get(Tables.EVENT.ID);
        return EventDTO.builder().id(id).created(((Timestamp)from.get(Tables.EVENT.CREATED)).toInstant()).userKey((String)from.get((Expression)Tables.EVENT.USER_KEY)).eventType((Long)from.get(Tables.EVENT.EVENT_TYPE)).action((String)from.get((Expression)Tables.EVENT.ACTION)).actionId((String)from.get((Expression)Tables.EVENT.ACTION_ID)).eventBundleId((String)from.get((Expression)Tables.EVENT.EVENT_BUNDLE_ID)).recipients(this.getRecipients(id, eventSearchParams)).parameters(this.getParameters(id)).build();
    }

    private Collection<Recipient> getRecipients(Long eventId, @Nullable EventSearchParams eventSearchParams) {
        Expression[] columns = new Expression[]{Tables.EVENT_RECIPIENT.ID, Tables.EVENT_RECIPIENT.USER_KEY, Tables.EVENT_RECIPIENT.EVENT_ID, Tables.EVENT_RECIPIENT.CONSUMER_NAME, Tables.EVENT_RECIPIENT.STATUS, Tables.EVENT_RECIPIENT.CREATED, Tables.EVENT_RECIPIENT.UPDATED, Tables.EVENT_RECIPIENT.SEND_DATE};
        List eventDbList = (List)this.databaseAccessor.runInTransaction(dbConnection -> {
            BooleanExpression expression = Tables.EVENT_RECIPIENT.EVENT_ID.eq((Object)eventId);
            if (eventSearchParams != null && eventSearchParams.getRecipientData() != null && eventSearchParams.getRecipientData().isFilterRecipients()) {
                for (Predicate predicate : this.eventSearcher.predicates(eventSearchParams.getRecipientData())) {
                    expression = expression.and(predicate);
                }
            }
            return ((SQLQuery)((SQLQuery)dbConnection.select(columns).from((Expression)Tables.EVENT_RECIPIENT)).where((Predicate)expression)).fetch();
        }, OnRollback.NOOP);
        return eventDbList.stream().map(this::toRecipient).collect(Collectors.toList());
    }

    private Collection<Parameter> getParameters(Long eventId) {
        Expression[] columns = new Expression[]{Tables.EVENT_PARAMETER.ID, Tables.EVENT_PARAMETER.NAME, Tables.EVENT_PARAMETER.VALUE, Tables.EVENT_PARAMETER.EVENT_ID};
        List eventDbList = (List)this.databaseAccessor.run(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.select(columns).from((Expression)Tables.EVENT_PARAMETER)).where((Predicate)Tables.EVENT_PARAMETER.EVENT_ID.eq((Object)eventId))).fetch());
        return eventDbList.stream().map(this::toParameter).collect(Collectors.toList());
    }

    private Parameter toParameter(Tuple tuple) {
        return new ParameterDTO((Long)tuple.get(Tables.EVENT_PARAMETER.ID), (String)tuple.get((Expression)Tables.EVENT_PARAMETER.NAME), (String)tuple.get((Expression)Tables.EVENT_PARAMETER.VALUE));
    }

    Instant toInstant(Timestamp timestamp) {
        return Optional.ofNullable(timestamp).map(Timestamp::toInstant).orElse(null);
    }

    Timestamp toTimestamp(Instant instant) {
        return Optional.ofNullable(instant).map(Timestamp::from).orElse(null);
    }

    private Recipient toRecipient(Tuple tuple) {
        return new RecipientDTO((Long)tuple.get(Tables.EVENT_RECIPIENT.ID), (String)tuple.get((Expression)Tables.EVENT_RECIPIENT.USER_KEY), (String)tuple.get((Expression)Tables.EVENT_RECIPIENT.CONSUMER_NAME), EventStatus.valueOf((String)((String)tuple.get((Expression)Tables.EVENT_RECIPIENT.STATUS))), this.toInstant((Timestamp)tuple.get(Tables.EVENT_RECIPIENT.CREATED)), this.toInstant((Timestamp)tuple.get(Tables.EVENT_RECIPIENT.UPDATED)), this.toInstant((Timestamp)tuple.get(Tables.EVENT_RECIPIENT.SEND_DATE)));
    }

    @VisibleForTesting
    static ComparableExpressionBase<?> orderableField(EventSearchParams.OrderableField field) {
        switch (field) {
            case ID: {
                return Tables.EVENT.ID;
            }
            case CREATED: {
                return Tables.EVENT.CREATED;
            }
            case EVENT_BUNDLE: {
                return Tables.EVENT.EVENT_BUNDLE_ID;
            }
            case USER_KEY: {
                return Tables.EVENT.USER_KEY;
            }
        }
        throw new IllegalArgumentException("No match found for OrderableField: " + field);
    }

    public long updateStatus(Collection<Long> recipientIds, EventStatus status) {
        long updated = (Long)this.databaseAccessor.runInTransaction(dbConnection -> {
            long ret = 0L;
            for (List recipientIdsBatch : Lists.partition(new ArrayList(recipientIds), (int)2000)) {
                ret += dbConnection.update((RelationalPath)Tables.EVENT_RECIPIENT).set((Path)Tables.EVENT_RECIPIENT.STATUS, (Object)status.toString()).set(Tables.EVENT_RECIPIENT.UPDATED, (Object)Timestamp.from(Instant.now())).where((Predicate)Tables.EVENT_RECIPIENT.ID.in((Collection)recipientIdsBatch)).execute();
            }
            return ret;
        }, OnRollback.NOOP);
        logger.debug(String.format("updated %d statuses", updated));
        return updated;
    }

    public long updateStatus(@Nonnull UpdateStatusParams updateStatusParams, @Nonnull EventStatus status) {
        long updated = (Long)this.databaseAccessor.runInTransaction(dbConnection -> {
            long ret = 0L;
            for (Predicate predicate : this.eventSearcher.predicates(updateStatusParams, 2000)) {
                ret += dbConnection.update((RelationalPath)Tables.EVENT_RECIPIENT).set((Path)Tables.EVENT_RECIPIENT.STATUS, (Object)status.toString()).set(Tables.EVENT_RECIPIENT.UPDATED, (Object)Timestamp.from(Instant.now())).where(predicate).execute();
            }
            return ret;
        }, OnRollback.NOOP);
        logger.debug(String.format("updated %d statuses", updated));
        return updated;
    }

    public Event get(Long id) {
        Expression[] columns = new Expression[]{Tables.EVENT.ID, Tables.EVENT.USER_KEY, Tables.EVENT.EVENT_TYPE, Tables.EVENT.CREATED, Tables.EVENT.ACTION, Tables.EVENT.ACTION_ID, Tables.EVENT.EVENT_BUNDLE_ID};
        Tuple event = (Tuple)this.databaseAccessor.runInTransaction(dbConnection -> (Tuple)((SQLQuery)((SQLQuery)dbConnection.select(columns).from((Expression)Tables.EVENT)).where((Predicate)Tables.EVENT.ID.eq((Object)id))).fetchFirst(), OnRollback.NOOP);
        return Optional.ofNullable(event).map(tuple -> this.toEvent((Tuple)tuple, null)).orElse(null);
    }

    public long deleteOlderThan(Instant olderThan) {
        long eventsDeletedBatch;
        logger.debug("deleting older than: " + olderThan);
        long eventsDeleted = 0L;
        do {
            eventsDeletedBatch = this.deleteOlderThanOneBatch(olderThan);
            eventsDeleted += eventsDeletedBatch;
        } while (eventsDeletedBatch > 0L);
        return eventsDeleted;
    }

    private long deleteOlderThanOneBatch(@Nonnull Instant olderThan) {
        long batchSize = this.getBatchSize();
        logger.debug("using batch size of {}", (Object)batchSize);
        return (Long)this.databaseAccessor.runInTransaction(dbConnection -> {
            List eventIds = ((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.select(Tables.EVENT.ID).from((Expression)Tables.EVENT)).where((Predicate)Tables.EVENT.CREATED.loe((Comparable)Timestamp.from(olderThan)))).limit(batchSize)).fetch();
            if (!eventIds.isEmpty()) {
                long parametersDeleted = dbConnection.delete((RelationalPath)Tables.EVENT_PARAMETER).where((Predicate)Tables.EVENT_PARAMETER.EVENT_ID.in((Collection)eventIds)).execute();
                logger.debug("deleted parameters: {}", (Object)parametersDeleted);
                long recipientsDeleted = dbConnection.delete((RelationalPath)Tables.EVENT_RECIPIENT).where((Predicate)Tables.EVENT_RECIPIENT.EVENT_ID.in((Collection)eventIds)).execute();
                logger.debug("deleted recipients: {}", (Object)recipientsDeleted);
                long eventsDeleted = dbConnection.delete((RelationalPath)Tables.EVENT).where((Predicate)Tables.EVENT.ID.in((Collection)eventIds)).execute();
                logger.debug("deleted events: {}", (Object)eventsDeleted);
                return eventsDeleted;
            }
            logger.debug("no events to delete, skipping");
            return 0L;
        }, OnRollback.NOOP);
    }

    public long removeRecipients(@Nonnull String userKey) {
        return (Long)this.databaseAccessor.run(dbConnection -> dbConnection.delete((RelationalPath)Tables.EVENT_RECIPIENT).where((Predicate)Tables.EVENT_RECIPIENT.USER_KEY.eq((Object)userKey)).execute(), OnRollback.NOOP);
    }

    @VisibleForTesting
    long getBatchSize() {
        Long batchSizeFromProperties = Optional.ofNullable(Longs.tryParse((String)System.getProperty(MAIL_BATCHING_CLEANUP_JOB_BATCH_SIZE_PROPERTY, Objects.toString(2000)))).orElse(2000L);
        return Math.max(1L, batchSizeFromProperties);
    }
}

