/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.listener;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEvent;
import com.atlassian.jira.event.issue.commit.OnCommitIssueEventBundle;
import com.atlassian.jira.plugins.inform.api.events.Event;
import com.atlassian.jira.plugins.inform.api.events.OnEventBundleSave;
import com.atlassian.jira.plugins.inform.api.events.convert.EventDbConverter;
import com.atlassian.jira.plugins.inform.api.events.dto.EventDTO;
import com.atlassian.jira.plugins.inform.events.listener.JiraEventListener;
import com.atlassian.jira.plugins.inform.events.listener.internal.EventSaver;
import com.atlassian.jira.plugins.inform.events.listener.internal.EventSplitter;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorkerFactory;
import com.atlassian.jira.plugins.inform.performance.events.PerformanceEvent;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraEventListenerImpl
implements JiraEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(JiraEventListenerImpl.class);
    private final EventSaver eventSaver;
    private final EventDbConverter eventDbConverter;
    private final MeasurementWorkerFactory measurementWorkerFactory;
    private final EventSplitter eventSplitter;
    private final EventPublisher eventPublisher;

    @Autowired
    public JiraEventListenerImpl(EventSaver eventSaver, EventDbConverter eventDbConverter, MeasurementWorkerFactory measurementWorkerFactory, EventSplitter eventSplitter, EventPublisher eventPublisher) {
        this.eventSaver = eventSaver;
        this.eventDbConverter = eventDbConverter;
        this.measurementWorkerFactory = measurementWorkerFactory;
        this.eventSplitter = eventSplitter;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void handleIssueEventBundle(OnCommitIssueEventBundle bundle) {
        this.measurementWorkerFactory.ofType(PerformanceEvent.Type.JIRA_EVENT_PROCESSING).measure(analyticParams -> {
            UUID eventBundleUUID = UUID.randomUUID();
            List saved = bundle.getOnCommitEvents().stream().map(e -> e.getWrappedEvent()).filter(event -> event instanceof DelegatingJiraIssueEvent).map(event -> (DelegatingJiraIssueEvent)event).map(delegatingJiraIssueEvent -> delegatingJiraIssueEvent.asIssueEvent()).flatMap(this.eventSplitter::splitEvent).map(arg_0 -> ((EventDbConverter)this.eventDbConverter).convert(arg_0)).map(event -> EventDTO.builder((Event)event).eventBundleId(eventBundleUUID.toString()).build()).map(this.eventSaver::save).collect(Collectors.toList());
            analyticParams.put("savedEventsCount", saved.size());
            this.eventPublisher.publish((Object)new OnEventBundleSave(saved));
            return null;
        });
    }

    @Override
    public void handleIssueEvent(OnCommitIssueEvent onCommitIssueEvent) {
        IssueEvent issueEvent = (IssueEvent)onCommitIssueEvent.getWrappedEvent();
        if (issueEvent.isRedundant()) {
            return;
        }
        this.measurementWorkerFactory.ofType(PerformanceEvent.Type.JIRA_EVENT_PROCESSING).measure(analyticParams -> {
            List saved = Stream.of(issueEvent).flatMap(e -> this.eventSplitter.splitEvent((IssueEvent)e)).map(e -> (Event)this.eventDbConverter.convert(e)).map(this.eventSaver::save).collect(Collectors.toList());
            analyticParams.put("savedEventsCount", saved.size());
            this.eventPublisher.publish((Object)new OnEventBundleSave(saved));
            return null;
        });
    }

    private Void save(Event event) {
        this.eventSaver.save(event);
        return null;
    }
}

