/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.listener;

import com.atlassian.jira.plugins.inform.api.events.Event;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.jira.plugins.inform.events.listener.internal.EventSaver;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorkerFactory;
import com.atlassian.jira.plugins.inform.performance.events.PerformanceEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventSaverImpl
implements EventSaver {
    private final EventManager eventManager;
    private final MeasurementWorkerFactory measurementWorkerFactory;

    @Autowired
    public EventSaverImpl(EventManager eventManager, MeasurementWorkerFactory measurementWorkerFactory) {
        this.eventManager = eventManager;
        this.measurementWorkerFactory = measurementWorkerFactory;
    }

    @Override
    public Event save(Event event) {
        return this.measurementWorkerFactory.ofType(PerformanceEvent.Type.SAVING_TO_DB).measure(parameters -> {
            parameters.put("recipients.size", event.getRecipients().size());
            parameters.put("parameters.size", event.getParameters().size());
            return this.eventManager.add(event);
        });
    }
}

