/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.listener;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.plugins.inform.api.events.IssueEventParameter;
import com.atlassian.jira.plugins.inform.events.listener.internal.EventSplitter;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultEventSplitter
implements EventSplitter {
    @Override
    public Stream<IssueEvent> splitEvent(IssueEvent issueEvent) {
        Worklog originalWorkLog;
        boolean issueUpdatedOrCommentDeletedEvent;
        Comment comment = issueEvent.getComment();
        Comment originalComment = (Comment)issueEvent.getParams().get("originalcomment");
        boolean workflowEvent = "workflow".equals(issueEvent.getParams().get("eventsource"));
        boolean originalCommentPresentAndRestricted = originalComment != null && this.isCommentRestricted(originalComment);
        boolean bl = issueUpdatedOrCommentDeletedEvent = (EventType.ISSUE_UPDATED_ID.equals(issueEvent.getEventTypeId()) || EventType.ISSUE_COMMENT_DELETED_ID.equals(issueEvent.getEventTypeId())) && comment == null;
        if (workflowEvent) {
            if (comment != null && this.isCommentRestricted(comment)) {
                IssueEvent newEvent = this.cloneIssueEventWithNewParams(issueEvent, (Map<String, Object>)ImmutableMap.builder().putAll(IssueEventParameter.INVERT_NEW_ENTITY_PERMISSIONS_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.SKIP_ENTITY_NEW_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.EVENT_SPLIT_PARAMETER.createParam((Object)true)).build());
                return Stream.of(issueEvent, newEvent);
            }
        } else if (issueUpdatedOrCommentDeletedEvent || EventType.ISSUE_COMMENT_EDITED_ID.equals(issueEvent.getEventTypeId())) {
            if (originalCommentPresentAndRestricted) {
                IssueEvent newEvent = this.cloneIssueEventWithNewParams(issueEvent, (Map<String, Object>)ImmutableMap.builder().putAll(IssueEventParameter.CHECK_PREVIOUS_COMMENT_PERMISSIONS_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.INVERT_PREVIOUS_ENTITY_PERMISSIONS_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.CLEAR_ENTITY_BEFORE_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.EVENT_SPLIT_PARAMETER.createParam((Object)true)).build());
                IssueEvent oldEvent = this.cloneIssueEventWithNewParams(issueEvent, (Map<String, Object>)ImmutableMap.builder().putAll(IssueEventParameter.CHECK_PREVIOUS_COMMENT_PERMISSIONS_PARAMETER.createParam((Object)true)).build());
                return Stream.of(oldEvent, newEvent);
            }
        } else if (EventType.ISSUE_WORKLOG_UPDATED_ID.equals(issueEvent.getEventTypeId()) && (originalWorkLog = (Worklog)issueEvent.getParams().get("originalworklog")) != null && (originalWorkLog.getGroupLevel() != null || originalWorkLog.getRoleLevelId() != null)) {
            IssueEvent newEvent = this.cloneIssueEventWithNewParams(issueEvent, (Map<String, Object>)ImmutableMap.builder().putAll(IssueEventParameter.CHECK_PREVIOUS_WORKLOG_PERMISSIONS_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.INVERT_PREVIOUS_ENTITY_PERMISSIONS_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.CLEAR_ENTITY_BEFORE_PARAMETER.createParam((Object)true)).putAll(IssueEventParameter.EVENT_SPLIT_PARAMETER.createParam((Object)true)).build());
            IssueEvent oldEvent = this.cloneIssueEventWithNewParams(issueEvent, (Map<String, Object>)ImmutableMap.builder().putAll(IssueEventParameter.CHECK_PREVIOUS_WORKLOG_PERMISSIONS_PARAMETER.createParam((Object)true)).build());
            return Stream.of(oldEvent, newEvent);
        }
        return Stream.of(issueEvent);
    }

    private boolean isCommentRestricted(Comment originalComment) {
        return originalComment.getGroupLevel() != null || originalComment.getRoleLevelId() != null;
    }

    private IssueEvent cloneIssueEventWithNewParams(IssueEvent issueEvent, @Nonnull Map<String, Object> additionalParams) {
        HashMap<String, Object> params = new HashMap<String, Object>(issueEvent.getParams());
        params.putAll(additionalParams);
        return new IssueEvent(issueEvent.getIssue(), issueEvent.getUser(), issueEvent.getComment(), issueEvent.getWorklog(), issueEvent.getChangeLog(), params, issueEvent.getEventTypeId(), issueEvent.isSendMail(), issueEvent.isSubtasksUpdated());
    }
}

