/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.convert.render;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.plugins.inform.events.convert.render.FieldRenderer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class DefaultFieldRenderer
implements FieldRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFieldRenderer.class);
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public DefaultFieldRenderer(@ComponentImport FieldLayoutManager fieldLayoutManager, @ComponentImport RendererManager rendererManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    @Nullable
    public String getRenderer(Issue issue, String fieldId) {
        return Optional.ofNullable(this.fieldLayoutManager.getFieldLayout(issue)).map(fieldLayout -> fieldLayout.getFieldLayoutItem(fieldId)).map(fieldLayoutItem -> fieldLayoutItem.getRendererType()).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(ApplicationUser forUser, Issue issue, String fieldId, String content) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        try {
            this.jiraAuthenticationContext.setLoggedInUser(forUser);
            String string = this.doRender(issue, content, this.getRenderer(issue, fieldId));
            return string;
        }
        finally {
            this.jiraAuthenticationContext.setLoggedInUser(currentUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String render(ApplicationUser forUser, String content, String rendererType) {
        ApplicationUser currentUser = this.jiraAuthenticationContext.getLoggedInUser();
        try {
            this.jiraAuthenticationContext.setLoggedInUser(forUser);
            String string = this.doRender(null, content, rendererType);
            return string;
        }
        finally {
            this.jiraAuthenticationContext.setLoggedInUser(currentUser);
        }
    }

    private String doRender(@Nullable Issue issue, String content, String rendererType) {
        if (content == null) {
            return null;
        }
        try {
            return this.rendererManager.getRenderedContent(rendererType, content, new IssueRenderContext(issue));
        }
        catch (Exception e) {
            LOG.warn("Unable to produce rendered version of the content for the issue " + Optional.ofNullable(issue).map(Issue::getKey).orElse("[none]") + " and renderer type " + rendererType, (Throwable)e);
            return JiraKeyUtils.linkBugKeys((String)content);
        }
    }
}

