/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.convert.parameters;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.mention.MentionService;
import com.atlassian.jira.plugins.inform.api.events.Parameter;
import com.atlassian.jira.plugins.inform.api.events.convert.ParameterConverter;
import com.atlassian.jira.plugins.inform.api.events.dto.ParameterDTO;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@ExportAsService(value={MentionParameterConverter.class})
@Component
@Order(value=650)
public class MentionParameterConverter
implements ParameterConverter<MentionedUserKeys> {
    private static final String PARAM_NAME_SEPARATOR = "#";
    private final MentionService mentionService;

    @Autowired
    public MentionParameterConverter(@ComponentImport MentionService mentionService) {
        this.mentionService = mentionService;
    }

    public Stream<Parameter> convertFrom(IssueEvent event) {
        MentionService.Mentions mentions = this.mentionService.getMentionedUsers(event);
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        this.addParamIfUsersMentioned(params, mentions.getIssueCommentMentions(), "comment_mentioned_user_keys");
        this.addParamIfUsersMentioned(params, mentions.getIssueDescriptionMentions(), "description_mentioned_user_keys");
        return params.stream();
    }

    private void addParamIfUsersMentioned(List<Parameter> params, Set<ApplicationUser> issueCommentMentions, String parameterNamePrefix) {
        if (!issueCommentMentions.isEmpty()) {
            params.addAll(this.createParameters(issueCommentMentions, parameterNamePrefix));
        }
    }

    private Collection<Parameter> createParameters(Set<ApplicationUser> mentionedUsers, String parameterNamePrefix) {
        Stream<String> mentionedUserKeys = mentionedUsers.stream().map(ApplicationUser::getKey);
        return Streams.mapWithIndex(mentionedUserKeys, (userKey, idx) -> new ParameterDTO(null, this.createParamName(parameterNamePrefix, idx), userKey)).collect(Collectors.toList());
    }

    private String createParamName(String parameterName, long idx) {
        return String.format("%s%s%d", parameterName, PARAM_NAME_SEPARATOR, idx);
    }

    public Optional<MentionedUserKeys> convertTo(Stream<Parameter> parameters, ParameterConverter.Context context) {
        List<Parameter> parameterList = parameters.collect(Collectors.toList());
        Set<String> mentionedInComments = this.mentionedInParameters(parameterList, "comment_mentioned_user_keys");
        Set<String> mentionedInDescription = this.mentionedInParameters(parameterList, "description_mentioned_user_keys");
        if (mentionedInComments.size() > 0 || mentionedInDescription.size() > 0) {
            return Optional.of(new MentionedUserKeys(mentionedInComments, mentionedInDescription));
        }
        return Optional.empty();
    }

    private Set<String> mentionedInParameters(List<Parameter> parameters, String parameterPrefix) {
        return parameters.stream().filter(p -> this.isMentionParameterWithPrefix(parameterPrefix, p.getName())).map(Parameter::getValue).collect(Collectors.toSet());
    }

    private boolean isMentionParameterWithPrefix(String prefix, String actualName) {
        return actualName.startsWith(prefix);
    }

    @ParametersAreNonnullByDefault
    @ReturnValuesAreNonnullByDefault
    public static class MentionedUserKeys {
        private final Set<String> inComments;
        private final Set<String> inDescription;

        public MentionedUserKeys(Set<String> inComments, Set<String> inDescription) {
            this.inComments = inComments;
            this.inDescription = inDescription;
        }

        public Set<String> getInComments() {
            return this.inComments;
        }

        public Set<String> getInDescription() {
            return this.inDescription;
        }

        public Set<String> getAll() {
            return ImmutableSet.builder().addAll(this.inComments).addAll(this.inDescription).build();
        }
    }
}

