/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.convert;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.plugins.inform.api.events.Parameter;
import com.atlassian.jira.plugins.inform.api.events.convert.ParameterConverter;
import com.atlassian.jira.plugins.inform.api.events.convert.ParameterProvider;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParameterProviderImpl
implements ParameterProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ParameterProviderImpl.class);
    private final List<ParameterConverter<?>> converters;

    @Autowired
    public ParameterProviderImpl(List<ParameterConverter<?>> converters) {
        this.converters = ImmutableList.copyOf(converters);
    }

    public Collection<Parameter> getParameters(IssueEvent issueEvent) {
        return this.converters.stream().flatMap(converter -> this.safe(arg_0 -> ((ParameterConverter)converter).convertFrom(arg_0)).apply(issueEvent)).collect(Collectors.toMap(Parameter::getName, Function.identity(), (first, second) -> second)).values();
    }

    private <F, T> Function<F, Stream<T>> safe(Function<F, Stream<T>> function) {
        return issueEvent -> {
            try {
                return (Stream)function.apply(issueEvent);
            }
            catch (Exception e) {
                LOG.warn("Exception during parameter provider", (Throwable)e);
                return Stream.of(new Object[0]);
            }
        };
    }
}

