/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.convert;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.plugin.OrderableModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugins.inform.api.events.Event;
import com.atlassian.jira.plugins.inform.api.events.convert.EventDbConverter;
import com.atlassian.jira.plugins.inform.api.events.convert.ParameterProvider;
import com.atlassian.jira.plugins.inform.api.events.convert.RecipientProvider;
import com.atlassian.jira.plugins.inform.api.events.dto.EventDTO;
import com.atlassian.jira.plugins.inform.events.module.ParameterProviderModuleDescriptor;
import com.atlassian.jira.plugins.inform.events.module.RecipientProviderModuleDescriptor;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorkerFactory;
import com.atlassian.jira.plugins.inform.performance.events.PerformanceEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConverterImpl
implements EventDbConverter {
    private static final Logger LOG = LoggerFactory.getLogger(EventConverterImpl.class);
    private final PluginAccessor pluginAccessor;
    private final MeasurementWorkerFactory measurementWorkerFactory;

    @Autowired
    public EventConverterImpl(@ComponentImport PluginAccessor pluginAccessor, MeasurementWorkerFactory measurementWorkerFactory) {
        this.pluginAccessor = pluginAccessor;
        this.measurementWorkerFactory = measurementWorkerFactory;
    }

    public Event convert(IssueEvent from) {
        return (Event)this.measurementWorkerFactory.ofType(PerformanceEvent.Type.CONVERTING_TO_DB).measure(eventParameters -> {
            EventDTO.Builder builder = EventDTO.builder();
            builder.created(from.getTime().toInstant()).userKey((String)Optional.ofNullable(from.getUser()).map(ApplicationUser::getKey).orElse(null)).eventType(from.getEventTypeId()).recipients((Collection)this.getRecipientProviders().stream().flatMap(rp -> this.safeGet(from, arg_0 -> ((RecipientProvider)rp).getRecipients(arg_0))).collect(Collectors.toList())).parameters((Collection)this.getParameterProviders().stream().flatMap(pp -> this.safeGet(from, arg_0 -> ((ParameterProvider)pp).getParameters(arg_0))).collect(Collectors.toList()));
            from.getSpanningOperation().ifPresent(spanningOperation -> {
                builder.action(spanningOperation.getType());
                builder.actionId(spanningOperation.getId());
            });
            EventDTO event = builder.build();
            eventParameters.put("recipients.size", event.getRecipients().size());
            eventParameters.put("parameters.size", event.getParameters().size());
            return event;
        });
    }

    private <F, T> Stream<T> safeGet(F argument, Function<F, Collection<T>> function) {
        try {
            return function.apply(argument).stream();
        }
        catch (Exception e) {
            LOG.error("Error occurred during recipient/parameter processing", (Throwable)e);
            return Stream.of(new Object[0]);
        }
    }

    private <M, MD extends OrderableModuleDescriptor & ModuleDescriptor<M>> Collection<M> getProviders(Class<MD> providerModuleDescriptor, Function<MD, M> getModule) {
        ArrayList providerModuleDescriptors = new ArrayList(this.pluginAccessor.getEnabledModuleDescriptorsByClass(providerModuleDescriptor));
        Collections.sort(providerModuleDescriptors, ModuleDescriptorComparator.COMPARATOR);
        return providerModuleDescriptors.stream().map(getModule).collect(Collectors.toList());
    }

    private Collection<RecipientProvider> getRecipientProviders() {
        return this.getProviders(RecipientProviderModuleDescriptor.class, RecipientProviderModuleDescriptor::getModule);
    }

    private Collection<ParameterProvider> getParameterProviders() {
        return this.getProviders(ParameterProviderModuleDescriptor.class, ParameterProviderModuleDescriptor::getModule);
    }
}

