/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.events.cleanup;

import com.atlassian.jira.plugins.inform.api.events.EventCleanupService;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class EventCleanupServiceImpl
implements EventCleanupService {
    private static final int DEFAULT_RETAIN_PERIOD = 14;
    private static final String CONFIGURATION_KEY = "com.atlassian.jira.plugins.inform.jira-inform-plugin";
    private final PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings globalSettings;
    private final EventManager eventManager;

    @Autowired
    public EventCleanupServiceImpl(@ComponentImport PluginSettingsFactory pluginSettingsFactory, EventManager eventManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.eventManager = eventManager;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public int getRetainPeriod() {
        String stored = (String)this.globalSettings.get(this.getRetainPeriodKey());
        return Optional.ofNullable(stored).map(Integer::parseInt).orElse(14);
    }

    public void setRetainPeriod(int days) {
        this.globalSettings.put(this.getRetainPeriodKey(), (Object)Integer.toString(days));
    }

    public long cleanup() {
        Instant olderThan = Instant.now().minus(Duration.of(this.getRetainPeriod(), ChronoUnit.DAYS));
        return this.eventManager.deleteOlderThan(olderThan);
    }

    private String getRetainPeriodKey() {
        return String.format("%s:event_retain_period", CONFIGURATION_KEY);
    }
}

