/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.cron;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class CronJobScheduler
implements LifecycleAware,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(CronJobScheduler.class);
    private final String pluginKey;
    private final SchedulerService schedulerService;
    private final JobRunner jobRunner;
    private final String jobKey;
    private final String cronExpression;
    private final JobId jobId;
    private final JobRunnerKey jobRunnerKey;
    private final RunMode runMode;
    private final EventPublisher eventPublisher;

    public CronJobScheduler(@Nonnull String pluginKey, SchedulerService schedulerService, JobRunner jobRunner, String jobKey, String cronExpression, RunMode runMode, EventPublisher eventPublisher) {
        this.pluginKey = Objects.requireNonNull(pluginKey);
        this.schedulerService = schedulerService;
        this.jobRunner = jobRunner;
        this.jobKey = jobKey;
        this.cronExpression = cronExpression;
        this.runMode = runMode;
        this.eventPublisher = eventPublisher;
        this.jobId = JobId.of((String)this.jobKey);
        this.jobRunnerKey = JobRunnerKey.of((String)this.jobKey);
    }

    public void onStart() {
        LOG.trace("Registering and scheduling {}", this.getClass());
        this.schedulerService.registerJobRunner(this.jobRunnerKey, this.jobRunner);
        try {
            this.schedulerService.scheduleJob(this.jobId, this.getJobConfig(this.jobRunnerKey));
            LOG.trace("{} schedule successfully completed", this.getClass());
        }
        catch (SchedulerServiceException e) {
            LOG.error("Error was thrown during scheduling an " + this.getClass(), (Throwable)e);
        }
    }

    private JobConfig getJobConfig(JobRunnerKey jobRunnerKey) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(Schedule.forCronExpression((String)this.cronExpression)).withRunMode(this.runMode);
    }

    public void onStop() {
    }

    @EventListener
    public void onPluginDisabling(PluginDisablingEvent event) {
        LOG.trace("PluginEvent " + event);
        if (event.getPlugin() != null && this.pluginKey.equals(event.getPlugin().getKey())) {
            LOG.trace("Unregistering and unscheduling {} with key: {}", this.getClass(), (Object)this.jobId.toString());
            this.schedulerService.unscheduleJob(this.jobId);
            this.schedulerService.unregisterJobRunner(this.jobRunnerKey);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }
}

