/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.upgradetasks;

import com.atlassian.jira.plugins.inform.api.batching.BatchNotificationJobScheduler;
import com.atlassian.upgrade.api.UpgradeContext;
import com.atlassian.upgrade.spi.UpgradeTask;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResetBatchingIntervalUpgradeTask
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(ResetBatchingIntervalUpgradeTask.class);
    private final BatchNotificationJobScheduler batchNotificationJobScheduler;

    public ResetBatchingIntervalUpgradeTask(BatchNotificationJobScheduler batchNotificationJobScheduler) {
        this.batchNotificationJobScheduler = batchNotificationJobScheduler;
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Resets the BatchNotificationJob interval to 1 minute. Fix for JRASERVER-71368";
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        log.info("Resetting the BatchNotificationJob execution interval to 1 minute.");
        this.batchNotificationJobScheduler.setInterval(Duration.ofMinutes(1L));
    }
}

