/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.rest;

import com.atlassian.jira.plugins.inform.api.batching.BatchingType;
import com.atlassian.jira.plugins.inform.api.batching.InstancePreferencesService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="configuration")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class BatchingConfigurationResource {
    private InstancePreferencesService instancePreferencesService;
    private I18nHelper i18nHelper;

    public BatchingConfigurationResource(InstancePreferencesService instancePreferencesService, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.instancePreferencesService = instancePreferencesService;
        this.i18nHelper = authenticationContext.getI18nHelper();
    }

    @GET
    @Path(value="interval")
    public Response getInstanceBatchingInterval() {
        BatchingType batchingType = this.instancePreferencesService.getBatchingType();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)batchingType.getValue()).build();
    }

    @PUT
    @Path(value="interval")
    public Response setInstanceBatchingInterval(String input) {
        int interval;
        try {
            interval = Integer.parseInt(input);
        }
        catch (Exception exception) {
            return this.getBatchingErrorResponse();
        }
        if (!BatchingType.getPossibleValues().contains(interval)) {
            return this.getBatchingErrorResponse();
        }
        BatchingType batchingType = BatchingType.getByValue((int)interval);
        this.instancePreferencesService.updateBatchingType(batchingType);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)batchingType).build();
    }

    @PUT
    @Path(value="batchingEnabled")
    public Response setBatchingEnabled(boolean enabled) {
        if (enabled) {
            this.instancePreferencesService.enableBatching();
        } else {
            this.instancePreferencesService.disableBatching();
        }
        return Response.ok().build();
    }

    private Response getBatchingErrorResponse() {
        String possibleValues = BatchingType.getPossibleValues().stream().map(Object::toString).collect(Collectors.joining(", "));
        String errorMessage = this.i18nHelper.getText("jira.inform.batching.types.wrong.number", possibleValues);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage).build();
    }
}

