/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.rendering;

import com.atlassian.jira.plugins.inform.api.batching.Batcher;
import com.atlassian.jira.plugins.inform.api.batching.BatchingType;
import com.atlassian.jira.plugins.inform.api.batching.MailType;
import com.atlassian.jira.plugins.inform.api.batching.Template;
import com.atlassian.jira.plugins.inform.api.batching.TemplateProvider;
import com.atlassian.jira.plugins.inform.batching.rendering.VelocityTemplate;
import com.atlassian.modzdetector.IOUtils;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TemplateProviderImpl
implements TemplateProvider {
    private static final Logger log = LoggerFactory.getLogger(TemplateProviderImpl.class);

    public Template getTemplate(Batcher batcher, BatchingType batchingType, MailType mailType) {
        String bodyTemplatePath = this.getTemplatePath(batcher, batchingType, mailType, "", "vm");
        String subjectTemplatePath = this.getTemplatePath(batcher, batchingType, mailType, "-subject", "vm");
        String cssPath = this.getTemplatePath(batcher, batchingType, mailType, "", "css");
        String bodyTemplate = this.getTemplateContent(batcher, bodyTemplatePath);
        String subjectTemplate = this.getTemplateContent(batcher, subjectTemplatePath);
        String cssContent = this.getTemplateContent(batcher, cssPath);
        return new VelocityTemplate(bodyTemplate, subjectTemplate, Optional.ofNullable(cssContent));
    }

    private String getTemplateContent(Batcher batcher, String templatePath) {
        InputStream templateStream = ClassLoaderUtils.getResourceAsStream((String)templatePath, batcher.getClass());
        if (templateStream != null) {
            try {
                return IOUtils.toString((InputStream)templateStream);
            }
            catch (IOException e) {
                log.error("Error reading template from classpath '" + templatePath + "'.", (Throwable)e);
            }
        }
        return null;
    }

    private String getTemplatePath(Batcher batcher, BatchingType batchingType, MailType mailType, String postfix, String extension) {
        String batchingTypePostfix = "";
        if (batchingType == BatchingType.DAILY) {
            batchingTypePostfix = "-daily";
        }
        String mailTypeString = mailType.toString().toLowerCase();
        return String.format("templates/email/batch/%s/%s%s%s.%s", mailTypeString, batcher.getName(), batchingTypePostfix, postfix, extension);
    }
}

