/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.cron.analytics;

import com.atlassian.jira.plugins.inform.api.batching.Batch;
import com.atlassian.jira.plugins.inform.api.batching.Batcher;
import com.atlassian.jira.plugins.inform.api.events.Event;
import com.atlassian.jira.plugins.inform.api.events.Recipient;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorkerFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(BatchStatistics.class);
    String eventConsumerName;
    int userCount;
    int eventCount;
    int mailEventBundleCount;
    int batchersCount;
    int recipientCount;
    long eventBundleRecipientCount;
    int mailCount;
    long redundantMentions;
    long redundantMentionsOmitted;

    public BatchStatistics(String eventConsumerName, int batchersCount) {
        this.eventConsumerName = eventConsumerName;
        this.batchersCount = batchersCount;
    }

    public BatchStatistics(String eventConsumerName, int userCount, int eventCount, int mailEventBundleCount, int batchersCount, int recipientCount, long eventBundleRecipientCount, int mailCount) {
        this.eventConsumerName = eventConsumerName;
        this.userCount = userCount;
        this.eventCount = eventCount;
        this.mailEventBundleCount = mailEventBundleCount;
        this.batchersCount = batchersCount;
        this.recipientCount = recipientCount;
        this.eventBundleRecipientCount = eventBundleRecipientCount;
        this.mailCount = mailCount;
    }

    public BatchStatistics add(BatchStatistics other) {
        this.userCount += other.userCount;
        this.eventCount += other.eventCount;
        this.mailEventBundleCount += other.mailEventBundleCount;
        this.recipientCount += other.recipientCount;
        this.eventBundleRecipientCount += other.eventBundleRecipientCount;
        this.mailCount += other.mailCount;
        this.redundantMentions += other.redundantMentions;
        this.redundantMentionsOmitted += other.redundantMentionsOmitted;
        return this;
    }

    private static long getBundleRecipientCount(Collection<Event> events) {
        return events.stream().collect(Collectors.groupingBy(event -> Optional.ofNullable(event.getEventBundleId()).orElse(Integer.toString(event.hashCode())))).values().stream().mapToLong(bundleEvents -> bundleEvents.stream().map(Event::getRecipients).flatMap(Collection::stream).map(Recipient::getUserKey).distinct().count()).sum();
    }

    public void batchProcessed(Batch batch) {
        ++this.mailCount;
        this.mailEventBundleCount = (int)((long)this.mailEventBundleCount + batch.getEvents().stream().map(Event::getEventBundleId).distinct().count());
    }

    public void redundantMentionsBatchOmitted() {
        ++this.redundantMentionsOmitted;
    }

    private String getEventConsumerName() {
        if (!"mailEventConsumer".equals(this.eventConsumerName)) {
            return Optional.of(this.eventConsumerName).map(Object::hashCode).map(hash -> Integer.toString(hash)).orElse("UNKNOWN");
        }
        return this.eventConsumerName;
    }

    public static BatchStatistics create(EventManager eventManager, String eventConsumerName, Map<String, Set<Event>> userToEvents, Collection<Batcher> batchers, Collection<Event> events) {
        return new BatchStatistics(eventConsumerName, userToEvents.size(), events.size(), 0, batchers.size(), events.stream().mapToInt(e -> e.getRecipients().size()).sum(), BatchStatistics.getBundleRecipientCount(events), 0);
    }

    public void populateAnalyticParams(MeasurementWorkerFactory.AnalyticParams analyticParams) {
        analyticParams.putNonTriggering("eventConsumer", this.getEventConsumerName()).putNonTriggering("batchersCount", this.batchersCount).put("userCount", this.userCount).put("eventCount", this.eventCount).put("recipientCount", this.recipientCount).put("eventBundleRecipientCount", this.eventBundleRecipientCount).put("mailCount", this.mailCount).put("mailEventBundleCount", this.mailEventBundleCount).put("redundantMentionsOmitted", this.redundantMentionsOmitted);
    }
}

