/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.cron;

import com.atlassian.jira.plugins.inform.api.batching.InstancePreferencesService;
import com.atlassian.jira.plugins.inform.api.events.Event;
import com.atlassian.jira.plugins.inform.api.events.EventSearchParams;
import com.atlassian.jira.plugins.inform.api.events.EventStatus;
import com.atlassian.jira.plugins.inform.api.events.convert.ParameterConverter;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.jira.plugins.inform.events.convert.ParameterConverters;
import com.atlassian.jira.plugins.inform.events.convert.parameters.MentionParameterConverter;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorkerFactory;
import com.atlassian.jira.plugins.inform.performance.events.PerformanceEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MemorySafeEventRetriever {
    private static final Logger log = LoggerFactory.getLogger(MemorySafeEventRetriever.class);
    private final EventManager eventManager;
    private final ParameterConverters.IssueParameterConverter issueParameterConverter;
    private final MentionParameterConverter mentionParameterConverter;
    private final InstancePreferencesService instancePreferencesService;
    private final MeasurementWorkerFactory measurementWorkerFactory;

    @Autowired
    public MemorySafeEventRetriever(@ComponentImport EventManager eventManager, @ComponentImport ParameterConverters.IssueParameterConverter issueParameterConverter, @ComponentImport MentionParameterConverter mentionParameterConverter, InstancePreferencesService instancePreferencesService, MeasurementWorkerFactory measurementWorkerFactory) {
        this.eventManager = eventManager;
        this.issueParameterConverter = issueParameterConverter;
        this.mentionParameterConverter = mentionParameterConverter;
        this.instancePreferencesService = instancePreferencesService;
        this.measurementWorkerFactory = measurementWorkerFactory;
    }

    public Collection<Event> getSomeEvents(String eventConsumerName, Collection<Long> supportedEventTypes, Instant sendDateTo) {
        Collection<Event> scheduledEvents = this.searchForScheduledEvents(eventConsumerName, supportedEventTypes, sendDateTo);
        if (this.shouldProcessFurther(scheduledEvents)) {
            Collection<Event> flushedEvents = new FlushedEventsRetriever(scheduledEvents, eventConsumerName, supportedEventTypes, sendDateTo).getFlushedEvents();
            return ImmutableList.builder().addAll(scheduledEvents).addAll(flushedEvents).build();
        }
        return scheduledEvents;
    }

    private boolean shouldProcessFurther(Collection<Event> scheduledEvents) {
        return !scheduledEvents.isEmpty() && (long)scheduledEvents.size() <= this.softMaxReturnedEventsCount();
    }

    private long softMaxReturnedEventsCount() {
        return this.instancePreferencesService.getMaxReturnedEventsNumber();
    }

    private Collection<Event> searchForScheduledEvents(String eventConsumerName, Collection<Long> supportedEventTypes, Instant sendDateTo) {
        EventSearchParams eventSearchParams = EventSearchParams.newBuilder().eventTypes(supportedEventTypes).recipientData(EventSearchParams.RecipientData.newBuilder().addStatus(EventStatus.NEW).eventConsumer(eventConsumerName).sendDateTo(sendDateTo).filterRecipients(true).build()).limit(Long.valueOf(this.softMaxReturnedEventsCount())).build();
        return this.measuredSearch(eventSearchParams, "scheduled");
    }

    private Collection<Event> measuredSearch(EventSearchParams eventSearchParams, String eventType) {
        return (Collection)this.measurementWorkerFactory.ofType(PerformanceEvent.Type.FETCHING_FROM_DB).measure(params -> {
            Collection events = this.eventManager.search(eventSearchParams);
            params.putNonTriggering("eventType", eventType).put("fetchedEventsCount", events.size());
            return events;
        });
    }

    private class FlushedEventsRetriever {
        private final String eventConsumerName;
        private final Collection<Long> supportedEventTypes;
        private final Instant sendDateTo;
        private final Collection<Event> scheduledEvents;
        private final ImmutableList.Builder<Event> builder = ImmutableList.builder();
        private long eventsLimit;

        public FlushedEventsRetriever(Collection<Event> scheduledEvents, String eventConsumerName, Collection<Long> supportedEventTypes, Instant sendDateTo) {
            this.scheduledEvents = scheduledEvents;
            this.eventsLimit = MemorySafeEventRetriever.this.softMaxReturnedEventsCount() - (long)scheduledEvents.size();
            this.eventConsumerName = eventConsumerName;
            this.supportedEventTypes = supportedEventTypes;
            this.sendDateTo = sendDateTo;
        }

        public Collection<Event> getFlushedEvents() {
            for (Event event : this.scheduledEvents) {
                Optional<String> issueKey = this.issueKeyForEvent(event);
                if (issueKey.isPresent()) {
                    this.addEventsFlushedByMention(issueKey.get(), event);
                    if (!this.eventLimitReached()) continue;
                    break;
                }
                log.warn("Could not extract issue key from event: " + event);
            }
            return this.builder.build();
        }

        public void addEventsFlushedByMention(String issueKey, Event event) {
            Set<String> userKeys = this.mentionedUsernamesForEvent(event);
            if (userKeys.isEmpty()) {
                return;
            }
            Collection<Event> flushedEvents = this.getFlushedEventsForNextKeyAndUserkeys(issueKey, userKeys);
            this.builder.addAll(flushedEvents);
            this.eventsLimit -= (long)flushedEvents.size();
        }

        public boolean eventLimitReached() {
            return this.eventsLimit > MemorySafeEventRetriever.this.softMaxReturnedEventsCount();
        }

        private Optional<String> issueKeyForEvent(Event event) {
            return MemorySafeEventRetriever.this.issueParameterConverter.convertTo(event.getParameters().stream(), (ParameterConverter.Context)new ParameterConverter.DefaultContext(null)).map(ParameterConverters.IssueView::getKey);
        }

        private Set<String> mentionedUsernamesForEvent(Event event) {
            return MemorySafeEventRetriever.this.mentionParameterConverter.convertTo(event.getParameters().stream(), (ParameterConverter.Context)new ParameterConverter.DefaultContext(null)).map(MentionParameterConverter.MentionedUserKeys::getAll).orElse((Set)ImmutableSet.of());
        }

        private Collection<Event> getFlushedEventsForNextKeyAndUserkeys(String issueKey, Set<String> userKeys) {
            EventSearchParams eventSearchParams = EventSearchParams.newBuilder().eventTypes(this.supportedEventTypes).eventParameters((Collection)ImmutableList.of((Object)new EventSearchParams.EventParameter(ParameterConverters.IssueParameterConverter.NAME_KEY, issueKey))).recipientData(EventSearchParams.RecipientData.newBuilder().addStatus(EventStatus.NEW).eventConsumer(this.eventConsumerName).recipients(userKeys).sendDateFrom(this.sendDateTo).filterRecipients(true).limitRecipients(true).build()).limit(Long.valueOf(MemorySafeEventRetriever.this.softMaxReturnedEventsCount())).build();
            return MemorySafeEventRetriever.this.measuredSearch(eventSearchParams, "flushed by mentions");
        }
    }
}

