/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.cron;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalJobRunner
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalJobRunner.class);
    private final JobRunner delegate;
    private final FeatureFlag featureFlag;
    private final FeatureManager featureManager;

    public ConditionalJobRunner(JobRunner delegate, FeatureFlag featureFlag, FeatureManager featureManager) {
        this.delegate = delegate;
        this.featureFlag = featureFlag;
        this.featureManager = featureManager;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (this.featureManager.isEnabled(this.featureFlag)) {
            return this.delegate.runJob(request);
        }
        LOG.debug("Feature {} disabled, skipping job", (Object)this.featureFlag);
        return null;
    }
}

