/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.cron;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.inform.api.batching.BatchNotificationJobScheduler;
import com.atlassian.jira.plugins.inform.batching.cron.BatchJobQualifier;
import com.atlassian.jira.plugins.inform.batching.cron.OncePerClusterJobRunner;
import com.atlassian.jira.plugins.inform.cron.CronJobScheduler;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class BatchNotificationJobSchedulerImpl
implements BatchNotificationJobScheduler,
LifecycleAware,
DisposableBean,
InitializingBean {
    public static final int DEFAULT_BATCHING_INTERVAL = 1;
    private static final Logger LOG = LoggerFactory.getLogger(CronJobScheduler.class);
    private static final String PLUGIN_KEY = "com.atlassian.jira.plugins.inform.batching-plugin";
    private static final String INTERVAL_SETTING_KEY = "com.atlassian.jira.plugins.inform.jira-inform-plugin:batching.interval.minutes";
    private final SchedulerService schedulerService;
    private final PluginSettings pluginSettings;
    private final JobRunner job;
    private final JobId jobId;
    private final JobId jobIdMentions;
    private final JobRunnerKey jobKey;
    private final EventPublisher eventPublisher;

    @Autowired
    public BatchNotificationJobSchedulerImpl(@ComponentImport SchedulerService schedulerService, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @BatchJobQualifier JobRunner batchNotificationJob, @ComponentImport EventPublisher eventPublisher) {
        this.schedulerService = schedulerService;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.job = batchNotificationJob;
        this.jobId = JobId.of((String)this.getClass().getName());
        this.jobIdMentions = JobId.of((String)(this.getClass().getName() + ".mentions"));
        this.jobKey = JobRunnerKey.of((String)this.getClass().getName());
        this.eventPublisher = eventPublisher;
    }

    public void onStart() {
        LOG.trace("Registering and scheduling BatchNotificationJob");
        this.schedulerService.registerJobRunner(this.jobKey, this.job);
        this.enableJobs();
    }

    public void onStop() {
    }

    @EventListener
    public void onPluginDisabling(PluginDisablingEvent event) {
        LOG.trace("PluginEvent " + event);
        if (event.getPlugin() != null && PLUGIN_KEY.equals(event.getPlugin().getKey())) {
            LOG.trace("Handling PluginEvent " + event);
            LOG.trace("Unregistering and unscheduling Jobs");
            this.disableJobs();
            LOG.trace("Unregistering and unscheduling JobRunners");
            this.schedulerService.unregisterJobRunner(this.jobKey);
        }
    }

    private void enableJobs() {
        this.enableJob(this.jobId, this.jobConfig("mailEventConsumer", this.getIntervalMinutes()));
    }

    private void disableJobs() {
        this.disableJob(this.jobId);
        this.disableJob(this.jobIdMentions);
    }

    private int getIntervalMinutes() {
        return Optional.ofNullable(this.pluginSettings.get(INTERVAL_SETTING_KEY)).map(Object::toString).flatMap(BatchNotificationJobSchedulerImpl::parseInt).orElse(1);
    }

    private void enableJob(JobId jobId, JobConfig jobConfig) {
        try {
            LOG.trace("Scheduling job {}, {}", (Object)jobId.toString(), (Object)jobConfig.toString());
            this.schedulerService.scheduleJob(jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            LOG.error(String.format("Error while scheduling BatchingNotificationJob %s", jobId.toString()), (Throwable)e);
        }
    }

    private void disableJob(JobId jobId) {
        LOG.trace("Disabling job {}", (Object)jobId.toString());
        this.schedulerService.unscheduleJob(jobId);
    }

    private JobConfig jobConfig(String eventConsumerName, int minutes) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)this.jobKey).withSchedule(Schedule.forInterval((long)Duration.ofMinutes(minutes).toMillis(), (Date)Date.from(Instant.now().plus((long)minutes, ChronoUnit.MINUTES)))).withParameters((Map)ImmutableMap.of((Object)"eventConsumerName", (Object)eventConsumerName, (Object)OncePerClusterJobRunner.LOCK_ID_PARAMETER, (Object)(this.job.getClass().getName() + "." + eventConsumerName))).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
    }

    private static Optional<Integer> parseInt(String s) {
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            LOG.error("The interval setting can't parsed", (Throwable)e);
            return Optional.empty();
        }
    }

    public void setInterval(Duration duration) {
        this.pluginSettings.put(INTERVAL_SETTING_KEY, (Object)String.valueOf(duration.toMinutes()));
        LOG.trace("Setting interval for batching - restarting BatchNotificationJob");
        this.disableJobs();
        this.enableJobs();
    }

    public Duration getInterval() {
        int interval = this.getIntervalMinutes();
        return Duration.ofMinutes(interval);
    }

    public void setIntervalMentions(int minutes) {
        LOG.warn("Noop setIntervalMention called");
    }

    public void destroy() throws Exception {
        LOG.trace("destroy callback");
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        LOG.trace("afterPropertiesSet callback");
        this.eventPublisher.register((Object)this);
    }
}

