/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.cron;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.JiraMailThreader;
import com.atlassian.jira.plugins.inform.api.batching.Batch;
import com.atlassian.jira.plugins.inform.api.batching.Batcher;
import com.atlassian.jira.plugins.inform.api.batching.BatcherOutcome;
import com.atlassian.jira.plugins.inform.api.batching.BatcherService;
import com.atlassian.jira.plugins.inform.api.batching.BatchingNotifier;
import com.atlassian.jira.plugins.inform.api.events.Event;
import com.atlassian.jira.plugins.inform.api.events.EventStatus;
import com.atlassian.jira.plugins.inform.api.events.MailLoggerFactory;
import com.atlassian.jira.plugins.inform.api.events.Recipient;
import com.atlassian.jira.plugins.inform.api.events.UpdateStatusParams;
import com.atlassian.jira.plugins.inform.api.events.managers.EventManager;
import com.atlassian.jira.plugins.inform.batching.cron.MemorySafeEventRetriever;
import com.atlassian.jira.plugins.inform.batching.cron.analytics.BatchStatistics;
import com.atlassian.jira.plugins.inform.performance.MeasurementWorkerFactory;
import com.atlassian.jira.plugins.inform.performance.events.PerformanceEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailThreader;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class BatchNotificationJob
implements JobRunner,
BatchingNotifier {
    private static final Logger LOG = MailLoggerFactory.getOutgoingMailLogger(BatchNotificationJob.class);
    public static final String EVENT_CONSUMER_NAME_PARAMETER = "eventConsumerName";
    private final BatcherService batcherService;
    private final MemorySafeEventRetriever eventRetriever;
    private final EventManager eventManager;
    private final MeasurementWorkerFactory measurementWorkerFactory;
    private final UserManager userManager;

    @Autowired
    public BatchNotificationJob(BatcherService batcherService, MemorySafeEventRetriever eventRetriever, @ComponentImport EventManager eventManager, @ComponentImport MeasurementWorkerFactory measurementWorkerFactory, @ComponentImport UserManager userManager) {
        this.batcherService = batcherService;
        this.eventRetriever = eventRetriever;
        this.eventManager = eventManager;
        this.measurementWorkerFactory = measurementWorkerFactory;
        this.userManager = userManager;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        String eventConsumerName = Objects.requireNonNull((String)jobRunnerRequest.getJobConfig().getParameters().get(EVENT_CONSUMER_NAME_PARAMETER), String.format("%s job config parameter is required", EVENT_CONSUMER_NAME_PARAMETER));
        try {
            this.notifyUsers(eventConsumerName);
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            LOG.error("Exception during batch notification job", (Throwable)e);
            return JobRunnerResponse.failed((String)"Exception during batch notification job");
        }
    }

    public Void notifyUsers(String eventConsumerName) {
        LOG.debug("running CronNotify.notifyUsers for {}", (Object)eventConsumerName);
        Collection batchers = this.batcherService.getBatchers(eventConsumerName);
        LOG.debug("batcher count for {}: {}", (Object)eventConsumerName, (Object)batchers.size());
        Collection<Long> supportedEventTypes = this.getSupportedEventIds(batchers);
        this.measurementWorkerFactory.ofType(PerformanceEvent.Type.BATCHING_JOB_BATCH_PROCESSING_ALL).measure(params -> {
            Instant sendDateTo = Instant.now();
            Collection<Event> events = this.eventRetriever.getSomeEvents(eventConsumerName, supportedEventTypes, sendDateTo);
            BatchStatistics statistics = this.processEventBatch(eventConsumerName, batchers, events);
            statistics.populateAnalyticParams((MeasurementWorkerFactory.AnalyticParams)params);
            return null;
        });
        return null;
    }

    private BatchStatistics processEventBatch(String eventConsumerName, Collection<Batcher> batchers, Collection<Event> events) {
        LOG.debug("event count {}", (Object)events.size());
        Map<String, Set<Event>> userToEvents = this.groupEventsByRecipient(events);
        LOG.debug("users grouped {}", (Object)userToEvents.size());
        BatchStatistics batchStatistics = BatchStatistics.create(this.eventManager, eventConsumerName, userToEvents, batchers, events);
        for (Map.Entry<String, Set<Event>> entry : userToEvents.entrySet()) {
            String userKey = entry.getKey();
            Collection userEvents = entry.getValue();
            ApplicationUser user = this.userManager.getUserByKey(userKey);
            if (user == null) {
                LOG.info("user not found {}", (Object)userKey);
                continue;
            }
            for (Batcher batcher : batchers) {
                List<Event> batcherEvents = this.getEventsSupportedByBatcher(userEvents, batcher);
                if (batcherEvents.isEmpty()) continue;
                try {
                    BatcherOutcome batcherOutcome = batcher.createBatch(new Batcher.BatcherContext(userKey, eventConsumerName), batcherEvents);
                    this.removeProcessedEvents(userEvents, batcherOutcome);
                    this.processBatches(batchStatistics, userKey, batcherOutcome);
                }
                catch (Exception e) {
                    LOG.error("Exception during batch processing loop", (Throwable)e);
                    this.updateStatus(this.getRecipientIds(batcherEvents.stream()), EventStatus.ERROR);
                }
            }
        }
        return batchStatistics;
    }

    private void processBatches(BatchStatistics batchStatistics, String userKey, BatcherOutcome batcherOutcome) {
        Collection batches = batcherOutcome.getBatches();
        for (Batch batch : batches) {
            if (batch.getEvents().isEmpty()) continue;
            Collection<Long> recipientIds = this.getRecipientIds(batch, userKey);
            if (batch.shouldBeSent()) {
                this.sendEmail(userKey, batch, recipientIds);
                LOG.debug("Sent batch for {} {}", (Object)userKey, (Object)batch.getEvents().size());
                batchStatistics.batchProcessed(batch);
                continue;
            }
            this.updateStatus(recipientIds, EventStatus.PROCESSED);
            LOG.debug("Marking batch for {} {} with redundant mentions as processed without sending", (Object)userKey, (Object)batch.getEvents().size());
            batchStatistics.redundantMentionsBatchOmitted();
        }
    }

    private void sendEmail(String userKey, Batch batch, Collection<Long> recipientIds) {
        this.updateStatus(recipientIds, EventStatus.PROCESSING);
        try {
            com.atlassian.jira.mail.Email email = this.batcherService.createEmail(batch);
            SingleMailQueueItem mailQueueItem = new SingleMailQueueItem((Email)email);
            this.singleOrNoneIssue(batch).ifPresent(issue -> mailQueueItem.setMailThreader((MailThreader)new JiraMailThreader(issue)));
            this.batcherService.sendEmail((MailQueueItem)mailQueueItem, () -> this.updateStatus(recipientIds, EventStatus.PROCESSED), () -> this.updateStatus(recipientIds, EventStatus.ERROR));
            LOG.debug("batch for {} sent", (Object)userKey);
        }
        catch (Exception e) {
            LOG.error("Exception during sending mail", (Throwable)e);
            this.updateStatus(recipientIds, EventStatus.ERROR);
        }
    }

    private Optional<Issue> singleOrNoneIssue(Batch batch) {
        if (batch.getIssues().size() == 1) {
            return Optional.of(batch.getIssues().iterator().next());
        }
        return Optional.empty();
    }

    private Collection<Long> getRecipientIds(Batch batch, String userKey) {
        return batch.getEvents().stream().map(Event::getRecipients).flatMap(Collection::stream).filter(r -> userKey.equals(r.getUserKey())).map(Recipient::getId).collect(Collectors.toSet());
    }

    private Collection<Long> getRecipientIds(Stream<Event> eventStream) {
        return eventStream.map(Event::getRecipients).flatMap(Collection::stream).map(Recipient::getId).collect(Collectors.toSet());
    }

    private void updateStatus(Collection<Long> recipientIds, EventStatus eventStatus) {
        this.eventManager.updateStatus(UpdateStatusParams.newBuilder().recipientIds(recipientIds).build(), eventStatus);
    }

    private void removeProcessedEvents(Collection<Event> userEvents, BatcherOutcome batcherOutcome) {
        userEvents.removeAll(batcherOutcome.getEventsInterestedIn());
        batcherOutcome.getBatches().forEach(batch -> userEvents.removeAll(batch.getEvents()));
    }

    private List<Event> getEventsSupportedByBatcher(Collection<Event> userEvents, Batcher batcher) {
        Collection batcherEventTypes = batcher.getSupportedEventTypes();
        return userEvents.stream().filter(e -> batcherEventTypes.contains(e.getEventType())).collect(Collectors.toList());
    }

    private Map<String, Set<Event>> groupEventsByRecipient(Collection<Event> events) {
        return events.stream().flatMap(e -> e.getRecipients().stream().map(r -> Pair.of((Object)r.getUserKey(), (Object)e))).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
    }

    private Collection<Long> getSupportedEventIds(Collection<Batcher> batchers) {
        return batchers.stream().map(Batcher::getSupportedEventTypes).flatMap(Collection::stream).collect(Collectors.toSet());
    }
}

