/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching.configuration;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class FeatureUsageManager {
    private static final String KEY_WAS_ENABLED = "com.atlassian.jira.plugins.inform.jira-inform-plugin:batching_was_enabled";
    private static final String WAS_ENABLED = "1";
    private final PluginSettings pluginSettings;

    public FeatureUsageManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public void markFeatureEnabled() {
        if (!this.wasFeatureEnabled()) {
            this.pluginSettings.put(KEY_WAS_ENABLED, (Object)WAS_ENABLED);
        }
    }

    public boolean wasFeatureEnabled() {
        return Optional.ofNullable(this.pluginSettings.get(KEY_WAS_ENABLED)).filter(WAS_ENABLED::equals).isPresent();
    }

    public void clearFeatureEnabled() {
        this.pluginSettings.remove(KEY_WAS_ENABLED);
    }
}

