/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.inform.batching;

import com.atlassian.jira.plugins.inform.api.batching.BatchingConfiguration;
import com.atlassian.jira.plugins.inform.api.batching.BatchingType;
import com.atlassian.jira.plugins.inform.api.batching.InstancePreferencesService;
import com.atlassian.jira.plugins.inform.api.batching.UserPreferencesService;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class UserPreferencesServiceImpl
implements UserPreferencesService {
    public static final String USER_PROPERTY_BATCHING_PERIOD_START = "jira.mail.batcher.batching_period_start";
    public static final String USER_PROPERTY_BATCHING_TYPE = "jira.mail.batcher.userconfig.batching_type";
    public static final String USER_PROPERTY_BATCHING_SEND_AT = "jira.mail.batcher.userconfig.batching_time";
    public static final String USER_PROPERTY_SEND_MENTIONS_IMMEDIATELY = "jira.mail.batcher.userconfig.mentions_immediately";
    private final UserPropertyManager userPropertyManager;
    private final TimeZoneManager timeZoneManager;
    private final InstancePreferencesService instancePreferencesService;

    @Autowired
    public UserPreferencesServiceImpl(@ComponentImport UserPropertyManager userPropertyManager, @ComponentImport TimeZoneManager timeZoneManager, InstancePreferencesService instancePreferencesService) {
        this.userPropertyManager = userPropertyManager;
        this.timeZoneManager = timeZoneManager;
        this.instancePreferencesService = instancePreferencesService;
    }

    public BatchingConfiguration getConfiguration(ApplicationUser user) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        int batchingType = BatchingType.INSTANCE.ordinal();
        if (propertySet.exists(USER_PROPERTY_BATCHING_TYPE)) {
            batchingType = propertySet.getInt(USER_PROPERTY_BATCHING_TYPE);
        }
        String sendAt = propertySet.getString(USER_PROPERTY_BATCHING_SEND_AT);
        LocalTime localTime = Optional.ofNullable(sendAt).map(LocalTime::parse).orElse(null);
        boolean sendMentionsImmediately = true;
        if (propertySet.exists(USER_PROPERTY_SEND_MENTIONS_IMMEDIATELY)) {
            sendMentionsImmediately = propertySet.getBoolean(USER_PROPERTY_SEND_MENTIONS_IMMEDIATELY);
        }
        return new BatchingConfiguration(BatchingType.values()[batchingType], localTime, sendMentionsImmediately);
    }

    public void updateConfiguration(ApplicationUser user, BatchingConfiguration configuration) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(configuration);
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setInt(USER_PROPERTY_BATCHING_TYPE, configuration.getBatchingType().ordinal());
        propertySet.setString(USER_PROPERTY_BATCHING_SEND_AT, configuration.getLocalTime().toString());
        propertySet.setBoolean(USER_PROPERTY_SEND_MENTIONS_IMMEDIATELY, configuration.isSendMentionsImmediately());
    }

    public Instant getNextNotificationTime(ApplicationUser user) {
        Objects.requireNonNull(user);
        Instant now = Instant.now();
        Long batchingPeriodStart = this.userPropertyManager.getPropertySet(user).getLong(USER_PROPERTY_BATCHING_PERIOD_START);
        BatchingConfiguration batchingConfiguration = this.getConfiguration(user);
        Instant batchingPeriodStartInstant = Instant.ofEpochMilli(batchingPeriodStart);
        Instant nextNotificationTime = this.getNextNotificationTime(user, now, batchingConfiguration, batchingPeriodStartInstant);
        if (nextNotificationTime.isBefore(now)) {
            this.userPropertyManager.getPropertySet(user).setLong(USER_PROPERTY_BATCHING_PERIOD_START, now.toEpochMilli());
            batchingPeriodStartInstant = now;
            nextNotificationTime = this.getNextNotificationTime(user, now, batchingConfiguration, batchingPeriodStartInstant);
        }
        return nextNotificationTime;
    }

    private Instant getNextNotificationTime(ApplicationUser user, Instant now, BatchingConfiguration batchingConfiguration, Instant batchingPeriodStartInstant) {
        BatchingType batchingType = batchingConfiguration.getBatchingType();
        if (batchingType == BatchingType.INSTANCE) {
            batchingType = this.instancePreferencesService.getBatchingType();
        }
        switch (batchingType) {
            case OFF: {
                return now;
            }
            case DAILY: {
                LocalTime configurationLocalTime = batchingConfiguration.getLocalTime();
                TimeZone userTimezone = this.timeZoneManager.getTimeZoneforUser(user);
                ZoneId userZoneId = userTimezone.toZoneId();
                ZonedDateTime batchingPeriodStartSystemDefaultTimezone = batchingPeriodStartInstant.atZone(ZoneId.systemDefault());
                ZonedDateTime batchingPeriodStartUserTimezone = batchingPeriodStartSystemDefaultTimezone.withZoneSameInstant(userZoneId);
                ZonedDateTime shouldRunOn = batchingPeriodStartUserTimezone.withHour(configurationLocalTime.getHour()).withMinute(configurationLocalTime.getMinute()).withSecond(0).withNano(0);
                while (shouldRunOn.isBefore(batchingPeriodStartSystemDefaultTimezone)) {
                    shouldRunOn = shouldRunOn.plus(1L, ChronoUnit.DAYS);
                }
                return shouldRunOn.toInstant();
            }
        }
        return batchingPeriodStartInstant.plus((long)batchingType.getValue(), ChronoUnit.MINUTES);
    }
}

