/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.util;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.jira.bc.ServiceOutcome;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Either;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.builder.ToStringBuilder;

@ParametersAreNonnullByDefault
public class ServiceOutcomeImpl<T>
implements com.atlassian.greenhopper.service.ServiceOutcome<T> {
    private static final Supplier<ErrorCollection> NO_ERRORS_SUPPLIER = new Supplier<ErrorCollection>(){

        @Override
        public ErrorCollection get() {
            return new ErrorCollection();
        }
    };
    private final Either<ErrorCollection, T> errorsOrValue;

    public static <T> com.atlassian.greenhopper.service.ServiceOutcome<T> ok(T returnedValue) {
        return new ServiceOutcomeImpl<T>(returnedValue);
    }

    public static <T> com.atlassian.greenhopper.service.ServiceOutcome<T> error(ErrorCollection.Reason reason, String messageKey, Object ... params) {
        ErrorCollection errors = new ErrorCollection();
        errors.addError(reason, messageKey, params);
        return new ServiceOutcomeImpl<T>(errors);
    }

    public static <T> com.atlassian.greenhopper.service.ServiceOutcome<T> error(String contextId, ErrorCollection.Reason reason, String messageKey, Object ... params) {
        ErrorCollection errors = new ErrorCollection();
        errors.addContextualError(reason, contextId, messageKey, params);
        return new ServiceOutcomeImpl<T>(errors);
    }

    public static <T> com.atlassian.greenhopper.service.ServiceOutcome<T> error(ServiceResult outcome) {
        Preconditions.checkNotNull((Object)outcome, (Object)"outcome");
        Preconditions.checkArgument((!outcome.isValid() ? 1 : 0) != 0, (Object)"Outcome must be invalid");
        return new ServiceOutcomeImpl<T>(outcome.getErrors());
    }

    public static <T> com.atlassian.greenhopper.service.ServiceOutcome<T> from(ErrorCollection errors) {
        return new ServiceOutcomeImpl<T>(errors);
    }

    public static <T> com.atlassian.greenhopper.service.ServiceOutcome<T> from(ServiceOutcome<T> jiraServiceOutcome) {
        if (jiraServiceOutcome.isValid()) {
            return new ServiceOutcomeImpl<Object>(jiraServiceOutcome.get());
        }
        return new ServiceOutcomeImpl<T>(ErrorCollection.fromJiraErrorCollectionWithReasons((com.atlassian.jira.util.ErrorCollection)jiraServiceOutcome.getErrorCollection()));
    }

    private ServiceOutcomeImpl(ErrorCollection errors) {
        Preconditions.checkArgument((boolean)errors.hasErrors(), (Object)"error collection can not be empty");
        this.errorsOrValue = Either.left((Object)errors);
    }

    private ServiceOutcomeImpl(T value) {
        this.errorsOrValue = Either.right(value);
    }

    public boolean isValid() {
        return this.errorsOrValue.isRight();
    }

    public boolean isInvalid() {
        return this.errorsOrValue.isLeft();
    }

    @Nonnull
    public ErrorCollection getErrors() {
        Either.LeftProjection projection = this.errorsOrValue.left();
        return (ErrorCollection)projection.getOrElse(NO_ERRORS_SUPPLIER);
    }

    @Nullable
    public T getValue() {
        return (T)this.errorsOrValue.right().getOrNull();
    }

    @Nonnull
    public T get() {
        return (T)this.errorsOrValue.right().get();
    }

    public <B> B fold(Function<ErrorCollection, B> onErrorFunction, Function<T, B> onSuccessFunction) {
        return (B)this.errorsOrValue.fold(onErrorFunction::apply, onSuccessFunction::apply);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

