/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.util;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Either;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResponseFactory {
    protected final ErrorCollectionTransformer errorCollectionTransformer;
    public static final javax.ws.rs.core.CacheControl NO_CACHE = new javax.ws.rs.core.CacheControl();

    @Autowired
    public ResponseFactory(ErrorCollectionTransformer errorCollectionTransformer) {
        this.errorCollectionTransformer = errorCollectionTransformer;
    }

    public Response errorsToResponse(com.atlassian.greenhopper.model.validation.ErrorCollection errorCollection) {
        com.atlassian.jira.util.ErrorCollection jiraErrorCollection = this.errorCollectionTransformer.toJiraErrorCollection(errorCollection);
        ErrorCollection restErrorCollection = ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)jiraErrorCollection);
        ErrorCollection.Reason reason = (ErrorCollection.Reason)MoreObjects.firstNonNull((Object)errorCollection.getDefinitiveReason(), (Object)ErrorCollection.Reason.VALIDATION_FAILED);
        return Response.status((Response.Status)reason.mappedStatus).entity((Object)restErrorCollection).cacheControl(NO_CACHE).build();
    }

    public Response errorsToResponse(ServiceOutcome<?> serviceOutcome) {
        return this.errorsToResponse(serviceOutcome.getErrors());
    }

    public Response errorsToResponse(ServiceResult serviceResult) {
        return this.errorsToResponse(serviceResult.getErrors());
    }

    public <T> Either<Response, T> errorsToResponse(Either<com.atlassian.greenhopper.model.validation.ErrorCollection, T> either) {
        return either.left().map(this::errorsToResponse);
    }

    public <T> Either<Response, T> outcomeToEither(ServiceOutcome<T> outcome) {
        if (outcome.isInvalid()) {
            return Either.left((Object)this.errorsToResponse(outcome.getErrors()));
        }
        return Either.right((Object)outcome.get());
    }

    public static Response okNoCache(Object entity) {
        return Response.ok((Object)entity).cacheControl(NO_CACHE).build();
    }

    public static Response multiResponseNoCache(Object entity) {
        return Response.status((int)207).entity(entity).cacheControl(NO_CACHE).build();
    }

    public static Response noContent() {
        return Response.noContent().cacheControl(NO_CACHE).build();
    }

    public static Response created(URI self, Object entity) {
        return Response.created((URI)self).entity(entity).cacheControl(CacheControl.never()).build();
    }

    static {
        NO_CACHE.setNoStore(true);
        NO_CACHE.setNoCache(true);
    }
}

