/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.util;

import com.atlassian.greenhopper.api.rest.util.ServiceOutcomeImpl;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;

public final class QueryParamParser {
    private QueryParamParser() {
    }

    public static ServiceOutcome<Boolean> parseBoolean(String value, String paramName) {
        Option<Boolean> booleanOption = QueryParamParser.parseBoolean(value);
        if (!booleanOption.isDefined()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.param.illegal.boolean.value", paramName, value);
        }
        return ServiceOutcomeImpl.ok(booleanOption.get());
    }

    public static Option<Boolean> parseBoolean(String value) {
        if (value.toLowerCase().equals("true")) {
            return Option.some((Object)true);
        }
        if (value.toLowerCase().equals("false")) {
            return Option.some((Object)false);
        }
        return Option.none();
    }

    public static <T extends Enum<T>> ServiceOutcome<Set<T>> parseEnumSet(String paramName, List<String> statesNames, final Class<T> clazz) {
        Either statesOrError = Eithers.sequenceRight((Iterable)Iterables.transform(statesNames, (Function)new Function<String, Either<String, T>>(){

            public Either<String, T> apply(String input) {
                try {
                    return Either.right(Enum.valueOf(clazz, input.toUpperCase()));
                }
                catch (Exception e) {
                    return Either.left((Object)input);
                }
            }
        }));
        if (statesOrError.isLeft()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.param.illegal.value", paramName, statesOrError.left().get());
        }
        Iterable states = (Iterable)statesOrError.right().get();
        return ServiceOutcomeImpl.ok(Sets.newEnumSet((Iterable)states, clazz));
    }
}

