/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.BeanFactory;
import com.atlassian.greenhopper.api.rest.bean.RestDateFormatter;
import com.atlassian.greenhopper.api.rest.bean.VersionBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.JiraUrlCodec;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionBeanFactory
implements BeanFactory<Version, VersionBean> {
    private final JiraBaseUrls jiraBaseUrls;

    @Autowired
    public VersionBeanFactory(JiraBaseUrls jiraBaseUrls) {
        this.jiraBaseUrls = jiraBaseUrls;
    }

    @Override
    public VersionBean toBean(Version from) {
        return VersionBean.builder().id(from.getId()).self(this.createSelfURI(from)).projectId(from.getProjectId()).name(from.getName()).description(from.getDescription()).archived(from.isArchived()).released(from.isReleased()).releaseDate(RestDateFormatter.formatDate(from.getReleaseDate())).build();
    }

    private URI createSelfURI(Version version) {
        return URI.create(this.jiraBaseUrls.restApi2BaseUrl() + "version/" + JiraUrlCodec.encode((String)version.getId().toString()));
    }
}

