/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.api.rest.bean;

import com.atlassian.greenhopper.api.rest.bean.PageBean;
import com.atlassian.greenhopper.service.Page;
import com.atlassian.greenhopper.service.PageRequest;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;

public class PageBeanFactory {
    public static <T> PageBean<T> createPageBean(List<T> allBeans, @Nullable Long startAt, @Nullable Integer maxResults) {
        Long start = PageBeanFactory.getStartNonLessThanZero(startAt);
        Integer limit = PageBeanFactory.getLimitNotHigherThanDefaultValue(PageRequest.MAX_PAGE_LIMIT, maxResults);
        ImmutableList paginatedBeans = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.skip(allBeans, (int)start.intValue()), (int)limit));
        boolean isLast = start.intValue() + paginatedBeans.size() == allBeans.size();
        return new PageBean(paginatedBeans, null, paginatedBeans.size(), start, isLast);
    }

    public static <T, S> PageBean<T> createPageBean(Page<S> page, Function<S, T> toBean) {
        ImmutableList beans = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)page.getValues(), toBean));
        return new PageBean(beans, page.getTotal(), page.maxResults(), page.getStart(), page.isLast());
    }

    private static Long getStartNonLessThanZero(Long start) {
        if (start == null) {
            return 0L;
        }
        return Math.max(0L, start);
    }

    private static Integer getLimitNotHigherThanDefaultValue(Integer defaultMaxResults, @Nullable Integer maxResult) {
        if (maxResult == null) {
            return defaultMaxResults;
        }
        return Math.min(maxResult, defaultMaxResults);
    }
}

